/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.model;

import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeType;
import java.util.ArrayList;
import java.util.List;

public final class AttributeList
extends ArrayList<Attribute> {
    private static final long serialVersionUID = -7374901160611244245L;

    public AttributeList() {
        super(1);
    }

    public void mergeAll(List<Attribute> otherList) {
        for (Attribute otherAttribute : otherList) {
            Attribute attribute = this.getAttribute(otherAttribute.getType());
            if (attribute == null) {
                this.add(otherAttribute);
                continue;
            }
            attribute.setValue(otherAttribute.getValue());
        }
    }

    @Override
    public boolean add(Attribute a) {
        super.add(a);
        this.trimToSize();
        return true;
    }

    private Attribute getAttribute(AttributeType type) {
        for (Attribute attribute : this) {
            if (!attribute.getType().equals((Object)type)) continue;
            return attribute;
        }
        return null;
    }

    public String getString(AttributeType type) {
        Attribute attribute = this.getAttribute(type);
        if (attribute == null) {
            return null;
        }
        Object value = attribute.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Integer getInt(AttributeType type) {
        String t = this.getString(type);
        if (t == null) {
            return null;
        }
        return Integer.valueOf(t);
    }
}

