/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.model;

import com.ibm.cognos.jmd.model.AttributeTypeList;
import java.util.List;

public enum AttributeType {
    NAME,
    DESCRIPTION,
    TABLE_TYPE,
    DATA_TYPE,
    VENDOR_TYPE,
    PRECISION,
    SCALE,
    NULLABLE,
    UNIQUE,
    SORT_ORDER,
    CATALOG,
    SCHEMA,
    TABLE,
    COLUMN,
    RETURNS_VALUE,
    TYPE,
    CARDINALITY,
    EXTERNAL_HOST_REF,
    TARGET_CATALOG,
    TARGET_SCHEMA,
    TARGET_REFOBJECT_NAME,
    ALL;


    public int bitmask() {
        if (this.equals((Object)ALL)) {
            return 131071;
        }
        return 1 << this.ordinal();
    }

    public static int pack(int mask, AttributeType ... attributes) {
        for (AttributeType a : attributes) {
            mask |= a.bitmask();
        }
        return mask;
    }

    public static int pack(AttributeType ... attributes) {
        return AttributeType.pack(0, attributes);
    }

    public static int pack(int mask, List<AttributeType> attributes) {
        for (AttributeType a : attributes) {
            mask |= a.bitmask();
        }
        return mask;
    }

    public static int pack(AttributeTypeList attributes) {
        return AttributeType.pack(0, attributes);
    }

    public static AttributeTypeList unpack(int mask) {
        AttributeTypeList attributes = new AttributeTypeList();
        if (mask != 0) {
            for (AttributeType a : AttributeType.values()) {
                int aMask = a.bitmask();
                if ((mask & aMask) == 0) continue;
                attributes.add(a);
                if ((mask ^= aMask) == 0) break;
            }
        }
        return attributes;
    }

    public static AttributeType[] unpackToArray(int mask) {
        AttributeTypeList attributes = AttributeType.unpack(mask);
        return attributes.toArray(new AttributeType[attributes.size()]);
    }
}

