/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ibm.cognos.jmd.exception.JMDDecodeException;
import com.ibm.cognos.jmd.exception.JMDEncodeException;
import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.cognos.jmd.model.JMDModelObject;
import com.ibm.cognos.jmd.model.JMDModelObjectComparator;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.util.Counters;
import com.ibm.cognos.jmd.util.ICodec;
import com.ibm.cognos.jmd.util.Utility;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="JMDModel")
@XmlType(propOrder={"root"})
public class JMDModel
implements IJMDModel {
    private JMDModelObject root = new JMDModelObject(ObjectType.MODEL_ROOT, new Attribute[0]);

    @Override
    public JMDModelObject add(JMDModelObject object, String ... pathparts) {
        return this.add(this.root, object, pathparts);
    }

    private JMDModelObject add(JMDModelObject ancestor, JMDModelObject child, String[] pathparts) {
        int childDepth;
        int ancestorDepth = ancestor.getObjectType().getDepth();
        if (ancestorDepth + 1 == (childDepth = child.getObjectType().getDepth())) {
            return ancestor.mergeChildByName(child);
        }
        ObjectType ancestorType = child.getObjectType().getAncestorTypeAtDepth(ancestorDepth + 1);
        if (ancestor.hasChildren()) {
            for (JMDModelObject o : ancestor.getChildren()) {
                if (!o.getObjectType().equals((Object)ancestorType) || !Utility.isSame(o.getAttributes().getString(AttributeType.NAME), pathparts[ancestorDepth])) continue;
                return this.add(o, child, pathparts);
            }
        }
        JMDModelObject longLostUncle = new JMDModelObject(ancestorType, new Attribute(AttributeType.NAME, pathparts[ancestorDepth]));
        ancestor.addChild(longLostUncle);
        return this.add(longLostUncle, child, pathparts);
    }

    @Override
    public JMDModelObject getRoot() {
        return this.root;
    }

    public void setRoot(JMDModelObject newRoot) {
        this.root = newRoot;
    }

    @Override
    public String encode(ICodec codec) throws JMDEncodeException {
        return codec.encode(this);
    }

    @Override
    public void decode(ICodec codec, String theText) throws JMDDecodeException {
        JMDModel o = (JMDModel)codec.decode(JMDModel.class, theText);
        this.root = o.root;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JMDModel o = (JMDModel)other;
        return this.root == o.root || this.root.equals(o.root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    @Override
    public void merge(IJMDModel other) {
        this.merge(this.root, other.getRoot());
    }

    private void merge(JMDModelObject node, JMDModelObject other) {
        if (other.hasChildren()) {
            for (JMDModelObject oChild : other.getChildren()) {
                JMDModelObject nChild = node.mergeChildByName(oChild);
                this.merge(nChild, oChild);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.walkToString(0, this.root, buffer);
        return buffer.toString();
    }

    @Override
    public void sort(String keyword) {
        this.doSort(this.root, keyword);
    }

    public void doSort(JMDModelObject node, String keyword) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<JMDModelObject> tempChildList = new ArrayList<JMDModelObject>();
        ArrayList<JMDModelObject> childrenList = node.getChildren();
        for (JMDModelObject child : childrenList) {
            if (child.getObjectType().toString().equals(keyword)) {
                tempChildList.add(child);
                indexes.add(childrenList.indexOf(child));
            }
            if (!child.hasChildren()) continue;
            this.doSort(child, keyword);
        }
        if (tempChildList.size() > 1) {
            Collections.sort(tempChildList, new JMDModelObjectComparator());
            this.mergerChildLists(node.getChildren(), tempChildList, indexes);
        }
    }

    private void walkToString(int depth, JMDModelObject node, StringBuffer buffer) {
        for (int i = 0; i < depth; ++i) {
            buffer.append("  ");
        }
        buffer.append(node);
        buffer.append("\n");
        if (node.hasChildren()) {
            for (JMDModelObject child : node.getChildren()) {
                this.walkToString(depth + 1, child, buffer);
            }
        }
    }

    @Override
    @JsonIgnore
    public Counters getCounters() {
        Counters stats = new Counters();
        this.gatherStatistics(stats, this.root);
        return stats;
    }

    private void gatherStatistics(Counters stats, JMDModelObject node) {
        if (node.hasChildren()) {
            for (JMDModelObject child : node.getChildren()) {
                String type = child.getObjectType().toString();
                if (type.equals("TABLE")) {
                    String tableType = child.getAttributes().getString(AttributeType.TABLE_TYPE);
                    String tableWithTableType = "TABLE (" + tableType + ")";
                    stats.incrementCounter(tableWithTableType);
                }
                stats.incrementCounter(type);
                this.gatherStatistics(stats, child);
            }
        }
    }

    private void mergerChildLists(ArrayList<JMDModelObject> list1, ArrayList<JMDModelObject> list2, ArrayList<Integer> indexes) {
        int j = 0;
        for (int i : indexes) {
            list1.remove(i);
            list1.add(i, list2.get(j));
            ++j;
        }
    }
}

