/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeList;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.util.Utility;
import java.util.ArrayList;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"objectType", "attributes", "children"})
@JsonIgnoreProperties(value={"parent"})
@JsonPropertyOrder(value={"objectType", "attributes", "child"})
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JMDModelObject {
    private static final int HASH_MAGIC = 31;
    @JsonProperty(value="child")
    private ArrayList<JMDModelObject> children = null;
    private JMDModelObject parent;
    private ObjectType objectType;
    private AttributeList attributes = new AttributeList();

    public JMDModelObject() {
    }

    public JMDModelObject(JMDModelObject other) {
        this.objectType = other.objectType;
        this.attributes.addAll(other.attributes);
    }

    public JMDModelObject(ObjectType type, Attribute ... newAttributes) {
        this.setObjectType(type);
        for (int i = 0; i < newAttributes.length; ++i) {
            this.attributes.add(newAttributes[i]);
        }
    }

    private void initializeChildren() {
        if (this.children == null) {
            this.children = new ArrayList(0);
        }
    }

    @XmlElement(name="child")
    public ArrayList<JMDModelObject> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<JMDModelObject> newChildren) {
        this.children = newChildren;
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType newObjectType) {
        this.objectType = newObjectType;
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeList newAttributes) {
        this.attributes = newAttributes;
    }

    public JMDModelObject getParent() {
        return this.parent;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && JMDModelObject.class == other.getClass()) {
            JMDModelObject o = (JMDModelObject)other;
            if (this.objectType == o.objectType && this.attributes.equals(o.attributes)) {
                if (!this.hasChildren() && !o.hasChildren()) {
                    return true;
                }
                if (this.hasChildren() && o.hasChildren() && this.children.size() == o.children.size() && this.children.containsAll(o.children)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hc = this.objectType.hashCode();
        if (this.hasChildren()) {
            for (JMDModelObject child : this.children) {
                hc = hc * 31 + child.hashCode();
            }
        }
        return hc;
    }

    public JMDModelObject addChild(JMDModelObject other) {
        this.initializeChildren();
        this.children.add(other);
        other.parent = this;
        return other;
    }

    public JMDModelObject mergeChildByName(JMDModelObject other) {
        String otherName = other.attributes.getString(AttributeType.NAME);
        if (this.hasChildren()) {
            for (JMDModelObject child : this.children) {
                if (!Utility.isSame(child.attributes.getString(AttributeType.NAME), otherName)) continue;
                if (other.attributes.size() > 1) {
                    child.attributes.mergeAll(other.attributes);
                }
                return child;
            }
        }
        JMDModelObject child = new JMDModelObject(other);
        this.addChild(child);
        return child;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.objectType == null) {
            sb.append("NA");
        } else {
            sb.append((Object)this.objectType);
        }
        sb.append(" : ");
        sb.append(this.attributes);
        return sb.toString();
    }

    public void beforeUnmarshal(Unmarshaller u, Object p) {
        this.initializeChildren();
    }

    public void afterUnmarshal(Unmarshaller u, Object p) {
        if (this.children.isEmpty()) {
            this.children = null;
        }
    }
}

