/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.selector;

import com.ibm.cognos.jmd.selector.FilterList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Filter {
    private static HashMap<String, Pattern> patternCache = new HashMap();
    private static HashMap<String, String> regexCache = new HashMap();
    private static final String ESCAPE_CODE = "\ufffd";
    public static final String ANY_STRING = "\ufffds";
    public static final String ANY_CHAR = "\ufffdc";
    public static final String OR = "\ufffdo";
    private static final String ANY_STRING_SUB_MAX = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
    private static final String ANY_STRING_SUB_MIN = "";
    private static final String ANY_CHAR_SUB = "\ufffd";
    private static final Pattern EXPRESSION_SPLITTER = Pattern.compile("(\ufffds)|(\ufffdc)|(\ufffdo)");
    private String expression;

    public Filter() {
    }

    public Filter(String theExpression) {
        this.setExpression(theExpression);
    }

    public Filter(FilterList filters) {
        this.makeOrExpression(filters);
    }

    private void makeOrExpression(FilterList filters) {
        filters.removeOverlappingFilters();
        StringBuilder expressionBuilder = new StringBuilder();
        boolean first = true;
        for (Filter f : filters) {
            if (first) {
                first = false;
            } else {
                expressionBuilder.append(OR);
            }
            expressionBuilder.append(f.getExpression());
        }
        this.expression = expressionBuilder.toString();
    }

    public boolean matchesAll() {
        return this.expression.equals(ANY_STRING);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String theExpression) {
        if (theExpression != null) {
            this.expression = this.simplify(theExpression);
        }
        if (this.hasOr()) {
            this.makeOrExpression(this.subFilters());
        }
    }

    public String asRegex() {
        String regex = regexCache.get(this.expression);
        if (regex == null) {
            StringBuilder regexBuilder = new StringBuilder();
            Matcher m = EXPRESSION_SPLITTER.matcher(this.expression);
            if (this.hasOr()) {
                regexBuilder.append("(");
            }
            int startOfLiteral = 0;
            while (m.find()) {
                if (m.start() != startOfLiteral) {
                    regexBuilder.append(Pattern.quote(this.expression.substring(startOfLiteral, m.start())));
                }
                if (this.expression.startsWith(ANY_STRING, m.start())) {
                    regexBuilder.append(".*");
                } else if (this.expression.startsWith(ANY_CHAR, m.start())) {
                    regexBuilder.append(".");
                } else {
                    regexBuilder.append(")|(");
                }
                startOfLiteral = m.end();
            }
            if (startOfLiteral < this.expression.length()) {
                regexBuilder.append(Pattern.quote(this.expression.substring(startOfLiteral)));
            }
            if (this.hasOr()) {
                regexBuilder.append(")");
            }
            regex = regexBuilder.toString();
            regexCache.put(this.expression, regex);
        }
        return regex;
    }

    public Pattern asPattern() {
        Pattern pattern = patternCache.get(this.expression);
        if (pattern == null) {
            pattern = Pattern.compile(this.asRegex());
            patternCache.put(this.expression, pattern);
        }
        return pattern;
    }

    public FilterList subFilters() {
        String[] expressions = this.expression.split(OR);
        FilterList filters = new FilterList();
        for (int i = 0; i < expressions.length; ++i) {
            filters.add(new Filter(expressions[i]));
        }
        return filters;
    }

    public boolean hasWildCards() {
        return this.expression.contains(ANY_STRING) || this.expression.contains(ANY_CHAR);
    }

    public boolean hasOr() {
        if (this.expression != null) {
            return this.expression.contains(OR);
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Filter o = (Filter)other;
        return this.expression.equals(o.expression);
    }

    private String simplify(String exp) {
        return exp.replaceAll("(\ufffds)+", ANY_STRING);
    }

    public boolean overlaps(Filter other) {
        if (this.hasOr() || other.hasOr()) {
            return this.overlapsWithOr(other);
        }
        return this.overlapsNoOr(other);
    }

    private boolean overlapsNoOr(Filter other) {
        String minText = other.getExpression().replace(ANY_STRING, ANY_STRING_SUB_MIN).replace(ANY_CHAR, "\ufffd");
        String maxText = other.getExpression().replace(ANY_STRING, ANY_STRING_SUB_MAX).replace(ANY_CHAR, "\ufffd");
        return this.asPattern().matcher(minText).matches() && this.asPattern().matcher(maxText).matches();
    }

    private boolean overlapsWithOr(Filter other) {
        for (Filter otherFilter : other.subFilters()) {
            boolean isOverlap = false;
            for (Filter filter : this.subFilters()) {
                if (!filter.overlapsNoOr(otherFilter)) continue;
                isOverlap = true;
                break;
            }
            if (isOverlap) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public String toString() {
        return this.expression.replaceAll(ANY_STRING, "{ANY_STRING}").replaceAll(ANY_CHAR, "{ANY_CHAR}").replaceAll(OR, "{OR}");
    }
}

