/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.selector;

import com.ibm.cognos.jmd.exception.JMDDecodeException;
import com.ibm.cognos.jmd.exception.JMDEncodeException;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.IJMDSelector;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import com.ibm.cognos.jmd.selector.SelectionCriteriaComparator;
import com.ibm.cognos.jmd.util.ICodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="JMDSelector")
@XmlType(propOrder={"selectionCriteria"})
public class JMDSelector
implements IJMDSelector {
    private boolean isSorted = true;
    private ArrayList<SelectionCriteria> selectionCriteria = new ArrayList();

    @Override
    public ArrayList<SelectionCriteria> getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public void setSelectionCriteria(ArrayList<SelectionCriteria> newSelectionCriteria) {
        this.selectionCriteria = newSelectionCriteria;
        this.isSorted = false;
    }

    @Override
    public String encode(ICodec codec) throws JMDEncodeException {
        return codec.encode(this);
    }

    @Override
    public void decode(ICodec codec, String theText) throws JMDDecodeException {
        JMDSelector o = (JMDSelector)codec.decode(JMDSelector.class, theText);
        this.selectionCriteria = o.selectionCriteria;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JMDSelector o = (JMDSelector)other;
        return this.selectionCriteria.equals(o.selectionCriteria);
    }

    public int hashCode() {
        return this.selectionCriteria.hashCode();
    }

    @Override
    public void addSelection(SelectionCriteria sc) {
        this.selectionCriteria.add(sc);
        this.isSorted = false;
    }

    @Override
    public void addCatalogSelection(String catalogFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.CATALOG, attributeTypes, catalogFilter);
        this.addSelection(sc);
    }

    @Override
    public void addSchemaSelection(String catalogFilter, String schemaFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.SCHEMA, attributeTypes, catalogFilter, schemaFilter);
        this.addSelection(sc);
    }

    @Override
    public void addTableSelection(String catalogFilter, String schemaFilter, String tableFilter, String tableTypeFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.TABLE, attributeTypes, catalogFilter, schemaFilter, tableFilter, tableTypeFilter);
        this.addSelection(sc);
    }

    @Override
    public void addSynonymSelection(String catalogFilter, String schemaFilter, String tableFilter, String tableTypeFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.SYNONYM, attributeTypes, catalogFilter, schemaFilter, tableFilter, tableTypeFilter);
        this.addSelection(sc);
    }

    @Override
    public void addColumnSelection(String catalogFilter, String schemaFilter, String tableFilter, String columnFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.COLUMN, attributeTypes, catalogFilter, schemaFilter, tableFilter, columnFilter);
        this.addSelection(sc);
    }

    @Override
    public void addSynonymColumnSelection(String catalogFilter, String schemaFilter, String tableFilter, String columnFilter, String targetCatalogFilter, String targetSchemaFilter, String targetObjectFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.SYNONYM_COLUMN, attributeTypes, catalogFilter, schemaFilter, tableFilter, columnFilter, targetCatalogFilter, targetSchemaFilter, targetObjectFilter);
        this.addSelection(sc);
    }

    @Override
    public void addIndexSelection(String catalogFilter, String schemaFilter, String tableFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.INDEX, attributeTypes, catalogFilter, schemaFilter, tableFilter);
        this.addSelection(sc);
    }

    @Override
    public void addIndexSelection(Set<String> options, String catalogFilter, String schemaFilter, String tableFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.INDEX, attributeTypes, catalogFilter, schemaFilter, tableFilter);
        sc.setOptions(options);
        this.addSelection(sc);
    }

    @Override
    public void addPrimaryKeySelection(String catalogFilter, String schemaFilter, String tableFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.PRIMARY_KEY, attributeTypes, catalogFilter, schemaFilter, tableFilter);
        this.addSelection(sc);
    }

    @Override
    public void addImportedKeySelection(String catalogFilter, String schemaFilter, String tableFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.IMPORTED_KEY, attributeTypes, catalogFilter, schemaFilter, tableFilter);
        this.addSelection(sc);
    }

    @Override
    public void addExportedKeySelection(String catalogFilter, String schemaFilter, String tableFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.EXPORTED_KEY, attributeTypes, catalogFilter, schemaFilter, tableFilter);
        this.addSelection(sc);
    }

    @Override
    public void addProcedureSelection(String catalogFilter, String schemaFilter, String procedureFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.PROCEDURE, attributeTypes, catalogFilter, schemaFilter, procedureFilter);
        this.addSelection(sc);
    }

    @Override
    public void addProcedureColumnsSelection(String catalogFilter, String schemaFilter, String procedureFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.PROCEDURE_COLUMN, attributeTypes, catalogFilter, schemaFilter, procedureFilter);
        this.addSelection(sc);
    }

    @Override
    public void addFunctionSelection(String catalogFilter, String schemaFilter, String functionFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.FUNCTION, attributeTypes, catalogFilter, schemaFilter, functionFilter);
        this.addSelection(sc);
    }

    @Override
    public void addFunctionColumnsSelection(String catalogFilter, String schemaFilter, String functionFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.FUNCTION_COLUMN, attributeTypes, catalogFilter, schemaFilter, functionFilter);
        this.addSelection(sc);
    }

    @Override
    public void addUDTSelection(String catalogFilter, String schemaFilter, String udtFilter, AttributeType ... attributeTypes) {
        if (catalogFilter == null) {
            catalogFilter = "\ufffds";
        }
        if (schemaFilter == null) {
            schemaFilter = "\ufffds";
        }
        SelectionCriteria sc = new SelectionCriteria(ObjectType.UDT, attributeTypes, catalogFilter, schemaFilter, udtFilter);
        this.addSelection(sc);
    }

    @Override
    public void selectAll(boolean includeColumns, boolean includeSynonymColumns, boolean includeIndexes, boolean includePrimaryKeys, boolean includeForeignKeys, AttributeType ... attributeTypes) {
        this.addCatalogSelection("\ufffds", attributeTypes);
        this.addSchemaSelection("\ufffds", "\ufffds", attributeTypes);
        this.addTableSelection("\ufffds", "\ufffds", "\ufffds", "\ufffds", attributeTypes);
        this.addProcedureSelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
        this.addFunctionSelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
        this.addUDTSelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
        if (includeColumns) {
            this.addColumnSelection("\ufffds", "\ufffds", "\ufffds", "\ufffds", attributeTypes);
            this.addProcedureColumnsSelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
            this.addFunctionColumnsSelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
        }
        if (includeSynonymColumns) {
            this.addSynonymColumnSelection("\ufffds", "\ufffds", "\ufffds", "\ufffds", "\ufffds", "\ufffds", "\ufffds", attributeTypes);
        }
        if (includeIndexes) {
            this.addIndexSelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
        }
        if (includePrimaryKeys) {
            this.addPrimaryKeySelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
        }
        if (includeForeignKeys) {
            this.addImportedKeySelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
            this.addExportedKeySelection("\ufffds", "\ufffds", "\ufffds", attributeTypes);
        }
        this.isSorted = false;
    }

    @Override
    public IJMDSelector copy() {
        JMDSelector selector = new JMDSelector();
        selector.getSelectionCriteria().addAll(this.getSelectionCriteria());
        selector.isSorted = this.isSorted;
        return selector;
    }

    @Override
    public void sortSelections() {
        if (!this.isSorted) {
            Collections.sort(this.getSelectionCriteria(), new SelectionCriteriaComparator());
            this.isSorted = true;
        }
    }

    @Override
    public void removeRedundantSelections() {
        if (this.selectionCriteria.size() > 1) {
            for (int i = 0; i < this.selectionCriteria.size(); ++i) {
                SelectionCriteria sc = this.selectionCriteria.get(i);
                if (!this.isRedundantSelection(sc, true, sc)) continue;
                this.selectionCriteria.remove(sc);
                --i;
            }
        }
    }

    @Override
    public boolean isRedundantSelection(SelectionCriteria testSc, boolean includeattributeTypes) {
        return this.isRedundantSelection(testSc, includeattributeTypes, null);
    }

    private boolean isRedundantSelection(SelectionCriteria testSc, boolean includeattributeTypes, SelectionCriteria ignore) {
        for (SelectionCriteria sc : this.selectionCriteria) {
            if (sc == ignore || !sc.getObjectType().equals((Object)testSc.getObjectType()) || !sc.getFilterList().overlaps(testSc.getFilterList())) continue;
            if (includeattributeTypes) {
                if (!sc.getAttributeTypes().containsAll(testSc.getAttributeTypes())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("{\n");
        for (SelectionCriteria sc : this.selectionCriteria) {
            text.append("  ");
            text.append(sc.toString());
            text.append("\n");
        }
        text.append("}\n");
        return text.toString();
    }
}

