/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.util;

import com.ibm.cognos.jmd.util.Counters;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class MemoryCounter {
    private static final int REFERENCE_SIZE = 4;
    private static final int ARRAY_OVERHEAD = 4;
    private static final int OBJECT_OVERHEAD = 8;
    private static final int OBJECT_BOUNDARY = 8;
    private long memoryUsed = 0L;
    private long elapsedTimeMillis = 0L;
    private int numberOfObjects = 0;
    IdentityHashMap<Class<?>, IdentitySet> visited = new IdentityHashMap();
    HashMap<Class<?>, ClassSummary> classSummaryCache = new HashMap();

    public MemoryCounter(Object o) {
        if (o == null) {
            return;
        }
        this.elapsedTimeMillis = System.currentTimeMillis();
        this.memoryUsed = this.computeMemoryUsed(o, o.getClass());
        this.elapsedTimeMillis = System.currentTimeMillis() - this.elapsedTimeMillis;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public String getMemoryUsedHR() {
        long mu = this.getMemoryUsed();
        String unit = "B";
        if (mu > 5120L) {
            unit = "KB";
            mu >>= 10;
        }
        if (mu > 5120L) {
            unit = "MB";
            mu >>= 10;
        }
        if (mu > 5120L) {
            unit = "GB";
            mu >>= 10;
        }
        return String.valueOf(mu) + unit;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public int getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public int getNumberOfUniqueObjects() {
        int count = 0;
        for (Class<?> c : this.visited.keySet()) {
            count += this.visited.get(c).size();
        }
        return count;
    }

    public int getNumberOfClasses() {
        return this.classSummaryCache.size();
    }

    public Counters getClassCounters() {
        Counters cc = new Counters();
        for (Class<?> c : this.visited.keySet()) {
            cc.setCounter(c.getName(), this.visited.get(c).size());
        }
        return cc;
    }

    private long computeMemoryUsed(Object o, Class<?> c) {
        long bytes;
        block7: {
            block8: {
                ++this.numberOfObjects;
                bytes = 0L;
                if (this.isRepeat(c, o)) break block7;
                if (!c.isArray()) break block8;
                bytes = 12L;
                int length = Array.getLength(o);
                if (length <= 0) break block7;
                Object ao = Array.get(o, 0);
                Class<?> ac = c.getComponentType();
                if (ao != null && ac.isPrimitive()) {
                    bytes += (long)(length * this.getPrimitiveSize(ac));
                } else {
                    bytes += (long)(length * 4);
                    for (int i = 0; i < length; ++i) {
                        ao = Array.get(o, i);
                        if (ao == null) continue;
                        bytes += this.computeMemoryUsed(ao, ao.getClass());
                    }
                }
                break block7;
            }
            ClassSummary summary = this.getClassSummary(c);
            bytes += summary.getOverhead();
            for (Field field : summary.getReferenceFields()) {
                Object fo = null;
                try {
                    field.setAccessible(true);
                    fo = field.get(o);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (fo == null) {
                    bytes += this.computeMemoryUsed(fo, Object.class);
                    continue;
                }
                bytes += this.computeMemoryUsed(fo, fo.getClass());
            }
        }
        return bytes;
    }

    private int getPrimitiveSize(Class<?> c) {
        if (c == Long.TYPE || c == Float.TYPE) {
            return 8;
        }
        if (c == Integer.TYPE || c == Float.TYPE) {
            return 4;
        }
        if (c == Character.TYPE || c == Short.TYPE) {
            return 2;
        }
        return 1;
    }

    private ClassSummary getClassSummary(Class<?> c) {
        ClassSummary summary = this.classSummaryCache.get(c);
        if (summary == null) {
            long overhead = 8L;
            ArrayList<Field> fields = new ArrayList<Field>();
            Class<?> k = c;
            do {
                for (Field field : k.getDeclaredFields()) {
                    if (field.isEnumConstant() || (field.getModifiers() & 8) != 0) continue;
                    Class<?> fclass = field.getType();
                    if (fclass.isPrimitive()) {
                        overhead += (long)this.getPrimitiveSize(fclass);
                        continue;
                    }
                    overhead += 4L;
                    fields.add(field);
                }
            } while ((k = k.getSuperclass()) != null && k != Object.class);
            long remainder = overhead % 8L;
            if (remainder != 0L) {
                overhead = overhead - remainder + 8L;
            }
            summary = new ClassSummary(overhead, fields);
            this.classSummaryCache.put(c, summary);
        }
        return summary;
    }

    private boolean isRepeat(Class<?> c, Object o) {
        if (o != null) {
            IdentitySet set = this.visited.get(c);
            if (set == null) {
                set = new IdentitySet();
                this.visited.put(c, set);
            }
            if (!set.containsKey(o)) {
                set.add(o);
                return false;
            }
        }
        return true;
    }

    private final class ClassSummary {
        private final long overhead;
        private final ArrayList<Field> referenceFields;

        public ClassSummary(long o, ArrayList<Field> rf) {
            this.overhead = o;
            this.referenceFields = rf;
        }

        public long getOverhead() {
            return this.overhead;
        }

        public ArrayList<Field> getReferenceFields() {
            return this.referenceFields;
        }
    }

    private final class IdentitySet
    extends IdentityHashMap<Object, Object> {
        private static final long serialVersionUID = 1L;

        public void add(Object o) {
            this.put(o, null);
        }
    }
}

