/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.provider.ps;

import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ProjectionBuilder;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.wrangler.api.WranglerException;

class AtomicCounters {
    private static final String COUNTER_COL_NAME = "counters";
    private static final String KEY_NAME = "name";
    private static final String KEY_COUNT = "count";
    private final IDocumentCollection countersCol;

    AtomicCounters(IDocumentDatabase db) throws WranglerException {
        try {
            this.countersCol = db.getDocumentCollection(COUNTER_COL_NAME);
            this.countersCol.ensureSortedIndex(new String[]{KEY_NAME}, new ESortOrder[]{ESortOrder.ASCENDING}, true, false);
        }
        catch (PersistenceException ex) {
            throw new WranglerException((Throwable)ex);
        }
    }

    public boolean initialize(String name, long value) throws WranglerException {
        try {
            IONObject doc = new IONObjectBuilder().put(KEY_NAME, (Object)name).put(KEY_COUNT, (Object)value).toDocument();
            this.countersCol.insert(doc);
            return true;
        }
        catch (PersistenceException.DuplicateKey ex) {
            return false;
        }
        catch (PersistenceException ex) {
            throw new WranglerException((Throwable)ex);
        }
    }

    public long get(String name) throws WranglerException {
        try {
            IONObject query = new QueryBuilder().equalTo(KEY_NAME, (Object)name).toDocument();
            Long count = (Long)this.countersCol.findOneAndProject(query, KEY_COUNT, Long.class, EReadPreference.PRIMARY);
            return null == count ? 0L : count;
        }
        catch (PersistenceException ex) {
            throw new WranglerException((Throwable)ex);
        }
    }

    public void set(String name, long newValue) throws WranglerException {
        try {
            IONObject query = new QueryBuilder().equalTo(KEY_NAME, (Object)name).toDocument();
            IONObject update = new UpdateBuilder().set(KEY_COUNT, (Object)newValue).toDocument();
            this.countersCol.update(query, update, true, false);
        }
        catch (PersistenceException ex) {
            throw new WranglerException((Throwable)ex);
        }
    }

    public boolean compareAndSet(String name, long expectedValue, long newValue) throws WranglerException {
        try {
            IONObject query = new QueryBuilder().equalTo(KEY_NAME, (Object)name).equalTo(KEY_COUNT, (Object)expectedValue).toDocument();
            IONObject update = new UpdateBuilder().set(KEY_COUNT, (Object)newValue).toDocument();
            return 0 != this.countersCol.update(query, update, false, false);
        }
        catch (PersistenceException ex) {
            throw new WranglerException((Throwable)ex);
        }
    }

    public long change(String name, long delta) throws WranglerException {
        try {
            IONObject query = new QueryBuilder().equalTo(KEY_NAME, (Object)name).toDocument();
            IONObject update = new UpdateBuilder().inc(KEY_COUNT, (Number)delta).toDocument();
            IONObject projection = new ProjectionBuilder().excludeId().include(new String[]{KEY_COUNT}).toDocument();
            IONObject result = this.countersCol.findOneAndUpdate(query, null, update, projection, true, true);
            return result.getLong(KEY_COUNT);
        }
        catch (PersistenceException ex) {
            throw new WranglerException((Throwable)ex);
        }
    }

    public void delete(String name) throws WranglerException {
        try {
            IONObject query = new QueryBuilder().equalTo(KEY_NAME, (Object)name).toDocument();
            this.countersCol.remove(query);
        }
        catch (PersistenceException ex) {
            throw new WranglerException((Throwable)ex);
        }
    }
}

