/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.provider.ps;

import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ProjectionBuilder;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONBinary;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.wrangler.api.DGroupMember;
import com.ibm.neo.wrangler.api.WranglerException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupManager {
    private static final String GROUP_MEMBERS_COL_NAME = "group-members";
    private static final String GROUP = "group";
    private static final String ID = "id";
    private static final String DATA = "data";
    private static final String TIME = "time";
    private static final int DEFAULT_MEMBER_TIMEOUT_SECONDS = 60;
    private static final int DEFAULT_MEMBER_RENEWAL_SECONDS = 30;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupManager.class);
    private final IDocumentCollection groupMembersCol;
    private final ScheduledExecutorService maintenanceExecutor;
    private final ConcurrentLinkedQueue<GroupMemberImpl> startedMembers = new ConcurrentLinkedQueue();

    public GroupManager(IDocumentDatabase coordDb) throws PersistenceException {
        this(coordDb, 60, 30);
    }

    public GroupManager(IDocumentDatabase coordDb, int memberTTLSeconds, int memberRenewalSeconds) throws PersistenceException {
        this.groupMembersCol = coordDb.getDocumentCollection(GROUP_MEMBERS_COL_NAME);
        this.groupMembersCol.ensureSortedIndex(new String[]{GROUP, ID}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, true, false);
        this.groupMembersCol.ensureTTLIndex(TIME, memberTTLSeconds);
        this.maintenanceExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Wrangler.GroupManager");
                t.setDaemon(true);
                return t;
            }
        });
        this.maintenanceExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                GroupManager.this.renewMemberships();
            }
        }, memberRenewalSeconds, memberRenewalSeconds, TimeUnit.SECONDS);
    }

    public DGroupMember createGroupMember(String group, String thisId, byte[] thisData) throws WranglerException {
        if (null == group) {
            throw new IllegalArgumentException("group was null");
        }
        if (null == thisId) {
            throw new IllegalArgumentException("thisId was null");
        }
        if (null == thisData) {
            throw new IllegalArgumentException("thisData was null");
        }
        return new GroupMemberImpl(group, thisId, thisData);
    }

    public void dispose() {
        this.maintenanceExecutor.shutdownNow();
        for (GroupMemberImpl member : this.startedMembers) {
            try {
                member.close();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to close group member (group={}, thisId={})", new Object[]{member.group, member.thisId, ex});
            }
        }
        this.startedMembers.clear();
    }

    private void renewMemberships() {
        for (GroupMemberImpl member : this.startedMembers) {
            try {
                IONObject update = new UpdateBuilder().set(TIME, (Object)new Date()).toDocument();
                member.updateOrInsert(update);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to renew membership (group={}, thisId={})", new Object[]{member.group, member.thisId, ex});
            }
        }
    }

    private final class GroupMemberImpl
    implements DGroupMember {
        private final String group;
        private final String thisId;
        private final AtomicReference<byte[]> thisDataRef;
        private final AtomicReference<Map<String, byte[]>> currentMembersRef;
        private volatile boolean started = false;

        GroupMemberImpl(String group, String thisId, byte[] thisData) {
            this.group = group;
            this.thisId = thisId;
            this.thisDataRef = new AtomicReference<byte[]>(thisData);
            this.currentMembersRef = new AtomicReference(Collections.emptyMap());
        }

        public String getThisId() {
            return this.thisId;
        }

        public byte[] getThisData() {
            return this.thisDataRef.get();
        }

        public Map<String, byte[]> getCurrentMembers() throws WranglerException {
            if (this.started) {
                IONObject query = new QueryBuilder().equalTo(GroupManager.GROUP, (Object)this.group).toDocument();
                IONObject project = new ProjectionBuilder().include(new String[]{GroupManager.ID, GroupManager.DATA}).exclude(new String[]{"_id"}).toDocument();
                try {
                    List result = GroupManager.this.groupMembersCol.find(query, project).toListAndClose();
                    HashMap<String, byte[]> members = new HashMap<String, byte[]>(result.size());
                    for (IONObject o : result) {
                        members.put(o.getString(GroupManager.ID), o.getIONBinary(GroupManager.DATA).getData());
                    }
                    this.currentMembersRef.set(members);
                    return members;
                }
                catch (Exception ex) {
                    throw new WranglerException((Throwable)ex);
                }
            }
            return this.currentMembersRef.get();
        }

        public void setThisData(byte[] data) throws WranglerException {
            this.thisDataRef.set(data);
            if (this.started) {
                IONObject update = new UpdateBuilder().set(GroupManager.DATA, (Object)new IONBinary(data)).set(GroupManager.TIME, (Object)new Date()).toDocument();
                try {
                    this.updateOrInsert(update);
                }
                catch (Exception ex) {
                    throw new WranglerException((Throwable)ex);
                }
            }
        }

        public void start() throws WranglerException {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            try {
                GroupManager.this.groupMembersCol.insert(new IONObjectBuilder().put(GroupManager.GROUP, (Object)this.group).put(GroupManager.ID, (Object)this.thisId).put(GroupManager.DATA, (Object)new IONBinary(this.thisDataRef.get())).put(GroupManager.TIME, (Object)new Date()).toDocument());
                GroupManager.this.startedMembers.add(this);
                this.started = true;
            }
            catch (PersistenceException ex) {
                throw new WranglerException((Throwable)ex);
            }
        }

        public void close() throws WranglerException {
            if (!this.started) {
                return;
            }
            this.started = false;
            GroupManager.this.startedMembers.remove(this);
            try {
                GroupManager.this.groupMembersCol.remove(new QueryBuilder().equalTo(GroupManager.GROUP, (Object)this.group).equalTo(GroupManager.ID, (Object)this.thisId).toDocument());
            }
            catch (PersistenceException ex) {
                throw new WranglerException((Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.started) {
                    LOGGER.error("Finalizing group membership (group={}, thisId={}). Forcing it to close", (Object)this.group, (Object)this.thisId);
                    this.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error", (Throwable)ex);
            }
            finally {
                super.finalize();
            }
        }

        private void updateOrInsert(IONObject update) throws PersistenceException {
            IONObject query = new QueryBuilder().equalTo(GroupManager.GROUP, (Object)this.group).equalTo(GroupManager.ID, (Object)this.thisId).toDocument();
            if (0 == GroupManager.this.groupMembersCol.update(query, update, false, false)) {
                GroupManager.this.groupMembersCol.insert(new IONObjectBuilder().put(GroupManager.GROUP, (Object)this.group).put(GroupManager.ID, (Object)this.thisId).put(GroupManager.DATA, (Object)new IONBinary(this.thisDataRef.get())).put(GroupManager.TIME, (Object)new Date()).toDocument());
            }
        }
    }
}

