/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.provider.ps;

import com.ibm.neo.wrangler.api.DLeaderLatch;
import com.ibm.neo.wrangler.api.DLeaderLatchListener;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerException;
import com.ibm.neo.wrangler.provider.ps.LockManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LeaderManager {
    private static final String LEADER_LOCK_PREFIX = "wrangler.leaderLatch.";
    private static final long ACQUIRE_TIMEOUT_MILLIS = 1000L;
    private static final long ACQUIRE_SLEEP_MILLIS = 100L;
    private static final long MAX_WAIT_MILLIS = 5000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderManager.class);
    private final LockManager lockManager;
    private final ConcurrentLinkedQueue<DLeaderLatchImpl> localLatchesStarted = new ConcurrentLinkedQueue();
    private final ExecutorService executor;

    public LeaderManager(LockManager lockManager) {
        this.lockManager = lockManager;
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicLong counter = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Wrangler.LeaderManager.Waiter-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public DLeaderLatch createLeaderLatch(String name) throws WranglerException {
        DLock leaderLock = this.lockManager.createLock(LEADER_LOCK_PREFIX + name);
        return new DLeaderLatchImpl(name, leaderLock);
    }

    public void dispose() {
        for (DLeaderLatchImpl latch : this.localLatchesStarted) {
            try {
                latch.close();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to close latch (name={}) on dispose", (Object)latch.name, (Object)ex);
            }
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final class SynchronousExecutor
    implements Executor {
        static final SynchronousExecutor INSTANCE = new SynchronousExecutor();

        private SynchronousExecutor() {
        }

        @Override
        public synchronized void execute(Runnable command) {
            try {
                command.run();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private final class DLeaderLatchImpl
    implements DLeaderLatch {
        private final String name;
        private final DLock leaderLock;
        private final Object awaitSync = new Object();
        private volatile boolean started = false;
        private Future<?> backgroundAcquire;
        private final ConcurrentHashMap<DLeaderLatchListener, Executor> listener2Executor = new ConcurrentHashMap();

        DLeaderLatchImpl(String name, DLock leaderLock) {
            this.name = name;
            this.leaderLock = leaderLock;
        }

        public synchronized void start() throws WranglerException {
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.started = true;
            LeaderManager.this.localLatchesStarted.add(this);
            this.acquireLeaderLockInBackground();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws WranglerException {
            if (!this.started) {
                return;
            }
            this.started = false;
            LeaderManager.this.localLatchesStarted.remove(this);
            if (null != this.backgroundAcquire) {
                this.backgroundAcquire.cancel(true);
                try {
                    this.backgroundAcquire.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.backgroundAcquire = null;
            }
            if (this.leaderLock.isHeld()) {
                try {
                    this.leaderLock.release();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to release leader lock for latch (name={})", (Object)this.name, (Object)ex);
                }
                this.fireListenersNotLeader();
            }
            Object object = this.awaitSync;
            synchronized (object) {
                this.awaitSync.notifyAll();
            }
        }

        private void acquireLeaderLockInBackground() {
            this.backgroundAcquire = LeaderManager.this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (DLeaderLatchImpl.this.started && !DLeaderLatchImpl.this.leaderLock.isHeld()) {
                        try {
                            if (DLeaderLatchImpl.this.leaderLock.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                                DLeaderLatchImpl.this.fireListenersIsLeader();
                                Object object = DLeaderLatchImpl.this.awaitSync;
                                synchronized (object) {
                                    DLeaderLatchImpl.this.awaitSync.notifyAll();
                                    break;
                                }
                            }
                        }
                        catch (WranglerException ex) {
                            LOGGER.error("Unexpected error", (Throwable)ex);
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            });
        }

        public boolean hasLeadership() throws WranglerException {
            return this.leaderLock.isHeld();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() throws WranglerException, InterruptedException {
            if (!this.started) {
                throw new IllegalStateException("Leader latch not started");
            }
            Object object = this.awaitSync;
            synchronized (object) {
                while (!this.leaderLock.isHeld()) {
                    if (!this.started) {
                        throw new WranglerException("Leader latch was closed");
                    }
                    this.awaitSync.wait(5000L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(long timeout, TimeUnit unit) throws WranglerException, InterruptedException {
            if (!this.started) {
                throw new IllegalStateException("Leader latch not started");
            }
            long startNanos = System.nanoTime();
            long timeoutNanos = unit.toNanos(timeout);
            Object object = this.awaitSync;
            synchronized (object) {
                while (!this.leaderLock.isHeld()) {
                    if (!this.started) {
                        throw new WranglerException("Leader latch was closed");
                    }
                    long nanosLeft = timeoutNanos - (System.nanoTime() - startNanos);
                    if (nanosLeft <= 0L) {
                        return false;
                    }
                    long waitMillis = Math.max(1L, Math.min(TimeUnit.NANOSECONDS.toMillis(nanosLeft), 5000L));
                    this.awaitSync.wait(waitMillis);
                }
            }
            return true;
        }

        public void addListener(DLeaderLatchListener listener) {
            this.addListener(listener, null);
        }

        public synchronized void addListener(DLeaderLatchListener listener, Executor executor) {
            if (null == listener) {
                throw new NullPointerException("listener was null");
            }
            if (null == executor) {
                this.listener2Executor.putIfAbsent(listener, SynchronousExecutor.INSTANCE);
            } else {
                this.listener2Executor.putIfAbsent(listener, executor);
            }
        }

        public synchronized void removeListener(DLeaderLatchListener listener) {
            this.listener2Executor.remove(listener);
        }

        private void fireListenersNotLeader() {
            for (Map.Entry<DLeaderLatchListener, Executor> e : this.listener2Executor.entrySet()) {
                final DLeaderLatchListener listener = e.getKey();
                Executor executor = e.getValue();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.notLeader((DLeaderLatch)DLeaderLatchImpl.this);
                    }
                });
            }
        }

        private void fireListenersIsLeader() {
            for (Map.Entry<DLeaderLatchListener, Executor> e : this.listener2Executor.entrySet()) {
                final DLeaderLatchListener listener = e.getKey();
                Executor executor = e.getValue();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.isLeader((DLeaderLatch)DLeaderLatchImpl.this);
                    }
                });
            }
        }
    }
}

