/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.provider.ps;

import com.ibm.neo.metrics.CounterMetric;
import com.ibm.neo.metrics.GaugeMetric;
import com.ibm.neo.metrics.TimerMetric;
import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.DLockProbe;
import com.ibm.neo.wrangler.api.WranglerException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockManager {
    private static final String LOCKS_HELD_COL_NAME = "locks.held";
    private static final String LOCKS_RELEASED_COL_NAME = "locks.released";
    private static final String NAME = "name";
    private static final String TIME = "time";
    private static final String SEQUENCE = "sequence";
    private static final String LOCK_ID = "lock-id";
    private static final int DEFAULT_LOCK_TIMEOUT_SECONDS = 120;
    private static final int DEFAULT_LOCK_RENEWAL_SECONDS = 30;
    private static final long MAX_RELEASE_WAIT_MILLIS = 5000L;
    private static final long ACQUIRE_SLEEP_MILLIS = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LockManager.class);
    private static final TimerMetric METRIC_LOCKS_ACQUIRE_TIME = new TimerMetric("wrangler.ps.locks.acquire_time");
    private static final TimerMetric METRIC_LOCKS_HELD_TIME = new TimerMetric("wrangler.ps.locks.held_time");
    private static final GaugeMetric METRIC_LOCKS_HELD = new GaugeMetric("wrangler.ps.locks.held");
    private static final CounterMetric METRIC_LOCKS_ACQUIRE_FAILED = new CounterMetric("wrangler.ps.locks.acquire_failed");
    private static final CounterMetric METRIC_LOCKS_ACQUIRE_TIMED_OUT = new CounterMetric("wrangler.ps.locks.acquire_timed_out");
    private static final CounterMetric METRIC_LOCKS_RELEASE_FAILED = new CounterMetric("wrangler.ps.locks.release_failed");
    private final IDocumentCollection locksHeldCol;
    private final IDocumentCollection locksReleasedCol;
    private final ConcurrentLinkedQueue<DLockImpl> localLocksHeld = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<DLockImpl> localLocksWaiting = new ConcurrentLinkedQueue();
    private final ScheduledExecutorService maintenanceExecutor;

    public LockManager(IDocumentDatabase coordDb) throws PersistenceException {
        this(coordDb, 120, 30);
    }

    public LockManager(IDocumentDatabase coordDb, int lockTTLSeconds, int lockRenewalSeconds) throws PersistenceException {
        this.locksHeldCol = coordDb.getDocumentCollection(LOCKS_HELD_COL_NAME);
        this.locksHeldCol.ensureSortedIndex(new String[]{NAME}, new ESortOrder[]{ESortOrder.ASCENDING}, true, false);
        this.locksHeldCol.ensureTTLIndex(TIME, lockTTLSeconds);
        if (coordDb.supportsCappedCollections()) {
            this.locksReleasedCol = coordDb.getCappedDocumentCollection(LOCKS_RELEASED_COL_NAME, 0x500000, 5000);
            if (this.locksReleasedCol.count() == 0L) {
                this.locksReleasedCol.insert(new IONObject());
            }
        } else {
            this.locksReleasedCol = null;
        }
        this.maintenanceExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Wrangler.LockManager");
                t.setDaemon(true);
                return t;
            }
        });
        this.maintenanceExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LockManager.this.renewHeldLocks();
            }
        }, lockRenewalSeconds, lockRenewalSeconds, TimeUnit.SECONDS);
        this.maintenanceExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LockManager.this.checkLockWaiters();
            }
        }, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public List<DLock> getLocalLocksHeld() throws PersistenceException {
        ArrayList<DLock> locks = new ArrayList<DLock>();
        for (DLock dLock : this.localLocksHeld) {
            locks.add(dLock);
        }
        return locks;
    }

    public DLock createLock(String name) {
        IONObjectId objectId = this.locksHeldCol.getGateway().generateId();
        return new DLockImpl(name, objectId);
    }

    public void dispose() {
        this.maintenanceExecutor.shutdownNow();
        for (DLockImpl lock : this.localLocksHeld) {
            try {
                lock.release();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to release lock (name={}) on dispose", (Object)lock.name, (Object)ex);
            }
        }
        this.localLocksHeld.clear();
    }

    private void renewHeldLocks() {
        for (DLockImpl lock : this.localLocksHeld) {
            try {
                IONObject lockUpdate = new UpdateBuilder().set(TIME, (Object)new Date()).toDocument();
                if (0 != this.locksHeldCol.update(lock.lockId, lockUpdate)) continue;
                LOGGER.error("Failed to renew lock (name={}), because it no longer exists", (Object)lock.name);
                this.localLocksHeld.remove(lock);
                lock.held = false;
                long heldTimeMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lock.acquiredAtNanos);
                METRIC_LOCKS_HELD_TIME.time(heldTimeMillis);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to renew lock (name={})", (Object)lock.name, (Object)ex);
            }
        }
        METRIC_LOCKS_HELD.gauge((long)this.localLocksHeld.size());
    }

    private void checkLockWaiters() {
        for (DLockImpl l : this.localLocksWaiting) {
            Thread waiter = l.waiter;
            if (l.held || null == waiter || System.nanoTime() - l.waitingSinceNanos <= TimeUnit.MILLISECONDS.toNanos(l.maxWaitMillis)) continue;
            LOGGER.info("Interrupting waiter (thread={}) for lock (name={})", (Object)waiter.getName(), (Object)l.getName());
            l.waiterTimedOut = true;
            waiter.interrupt();
        }
    }

    private final class DLockImpl
    implements DLock {
        private final String name;
        private final IONObjectId lockId;
        private IEvent heldEvent;
        private volatile long sequence = 0L;
        private volatile long acquiredAtNanos = 0L;
        private volatile boolean held = false;
        private volatile Thread waiter = null;
        private volatile boolean waiterTimedOut = false;
        private volatile long maxWaitMillis = 0L;
        private volatile long waitingSinceNanos = 0L;

        DLockImpl(String name, IONObjectId lockId) {
            this.name = name;
            this.lockId = lockId;
        }

        String getName() {
            return this.name;
        }

        public boolean isHeld() {
            return this.held;
        }

        public synchronized void acquire() throws WranglerException, InterruptedException {
            IEvent acquireEvent = DLockProbe.startAcquire((String)this.name);
            long startNanos = System.nanoTime();
            try {
                if (this.held) {
                    throw new IllegalStateException("Lock was already held");
                }
                while (!this.doTryAcquire()) {
                    if (this.waitForRelease(5000L)) continue;
                    Thread.sleep(100L);
                }
                long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                METRIC_LOCKS_ACQUIRE_TIME.time(elapsedMillis);
                METRIC_LOCKS_HELD.gauge((long)LockManager.this.localLocksHeld.size());
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)true, null);
                this.heldEvent = DLockProbe.startHeld((String)this.name);
            }
            catch (PersistenceException.Interrupted ex) {
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)false, (Throwable)ex);
                throw new InterruptedException();
            }
            catch (Exception ex) {
                METRIC_LOCKS_ACQUIRE_FAILED.count(1L);
                LOGGER.error("Failed to acquire the lock", (Throwable)ex);
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)false, (Throwable)ex);
                throw new WranglerException((Throwable)ex);
            }
        }

        public synchronized boolean tryAcquire() throws WranglerException {
            IEvent acquireEvent = DLockProbe.startAcquire((String)this.name);
            long startNanos = System.nanoTime();
            try {
                if (this.held) {
                    throw new IllegalStateException("Lock was already held");
                }
                boolean acquired = this.doTryAcquire();
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)acquired, null);
                if (acquired) {
                    long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                    METRIC_LOCKS_ACQUIRE_TIME.time(elapsedMillis);
                    METRIC_LOCKS_HELD.gauge((long)LockManager.this.localLocksHeld.size());
                    this.heldEvent = DLockProbe.startHeld((String)this.name);
                }
                return acquired;
            }
            catch (InterruptedException ex) {
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)false, (Throwable)ex);
                return false;
            }
            catch (PersistenceException.Interrupted ex) {
                return false;
            }
            catch (Exception ex) {
                METRIC_LOCKS_ACQUIRE_FAILED.count(1L);
                LOGGER.error("Failed to acquire the lock", (Throwable)ex);
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)false, (Throwable)ex);
                throw new WranglerException((Throwable)ex);
            }
        }

        public synchronized boolean tryAcquire(long timeout, TimeUnit unit) throws WranglerException, InterruptedException {
            long timeoutNanos = unit.toNanos(timeout);
            long startNanos = System.nanoTime();
            IEvent acquireEvent = DLockProbe.startAcquire((String)this.name);
            try {
                if (this.held) {
                    throw new IllegalStateException("Lock was already held");
                }
                while (System.nanoTime() - startNanos < timeoutNanos) {
                    if (this.doTryAcquire()) {
                        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                        METRIC_LOCKS_ACQUIRE_TIME.time(elapsedMillis);
                        METRIC_LOCKS_HELD.gauge((long)LockManager.this.localLocksHeld.size());
                        DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)true, null);
                        this.heldEvent = DLockProbe.startHeld((String)this.name);
                        return true;
                    }
                    long nanosLeft = timeoutNanos - (System.nanoTime() - startNanos);
                    if (nanosLeft <= 0L || this.waitForRelease(TimeUnit.NANOSECONDS.toMillis(nanosLeft))) continue;
                    Thread.sleep(100L);
                }
            }
            catch (PersistenceException.Interrupted ex) {
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)false, (Throwable)ex);
                throw new InterruptedException();
            }
            catch (Exception ex) {
                METRIC_LOCKS_ACQUIRE_FAILED.count(1L);
                LOGGER.error("Failed to acquire the lock", (Throwable)ex);
                DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)false, (Throwable)ex);
                throw new WranglerException((Throwable)ex);
            }
            METRIC_LOCKS_ACQUIRE_TIMED_OUT.count(1L);
            DLockProbe.endAcquire((IEvent)acquireEvent, (boolean)false, null);
            return false;
        }

        public synchronized void release() throws WranglerException {
            if (!this.held) {
                throw new IllegalStateException("Lock was not acquired");
            }
            try {
                LockManager.this.localLocksHeld.remove(this);
                LockManager.this.locksHeldCol.remove(this.lockId);
                this.held = false;
                if (null != LockManager.this.locksReleasedCol) {
                    LockManager.this.locksReleasedCol.insert(new IONObjectBuilder().put(LockManager.LOCK_ID, (Object)this.lockId).put(LockManager.SEQUENCE, (Object)(this.sequence - 1L)).toDocument());
                }
                long heldTimeMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.acquiredAtNanos);
                METRIC_LOCKS_HELD_TIME.time(heldTimeMillis);
                DLockProbe.endHeld((IEvent)this.heldEvent, null);
                this.heldEvent = null;
            }
            catch (Exception ex) {
                METRIC_LOCKS_RELEASE_FAILED.count(1L);
                LOGGER.error("Failed to release the lock", (Throwable)ex);
                DLockProbe.endHeld((IEvent)this.heldEvent, (Throwable)ex);
                throw new WranglerException((Throwable)ex);
            }
            finally {
                METRIC_LOCKS_HELD.gauge((long)LockManager.this.localLocksHeld.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.isHeld()) {
                    LOGGER.error("A held lock was finalized before release! This is a defect.");
                    DLockProbe.setLeaked((IEvent)this.heldEvent);
                    this.release();
                }
            }
            catch (Exception exception) {
            }
            finally {
                super.finalize();
            }
        }

        private boolean doTryAcquire() throws PersistenceException, InterruptedException {
            IONObject lockEntry = new IONObjectBuilder().putPrimaryId(this.lockId).put(LockManager.NAME, (Object)this.name).put(LockManager.SEQUENCE, (Object)this.sequence).put(LockManager.TIME, (Object)new Date()).toDocument();
            try {
                LockManager.this.locksHeldCol.insert(lockEntry);
                LockManager.this.localLocksHeld.add(this);
                this.acquiredAtNanos = System.nanoTime();
                this.held = true;
                ++this.sequence;
                return true;
            }
            catch (PersistenceException.DuplicateKey ex) {
                return false;
            }
        }

        private boolean waitForRelease(long timeoutMillis) throws PersistenceException, InterruptedException {
            if (null == LockManager.this.locksReleasedCol || !LockManager.this.locksReleasedCol.supportsCursorOption(ECursorOption.TAILABLE)) {
                Thread.sleep(Math.min(500L, timeoutMillis));
                return false;
            }
            IONObject lockEntry = LockManager.this.locksHeldCol.findOne(new QueryBuilder().equalTo(LockManager.NAME, (Object)this.name).toDocument(), EReadPreference.PRIMARY);
            if (null == lockEntry) {
                return true;
            }
            ICursor cur = LockManager.this.locksReleasedCol.tail(new QueryBuilder().equalTo(LockManager.LOCK_ID, (Object)lockEntry.getPrimaryId()).greaterThanOrEqualTo(LockManager.SEQUENCE, (Object)lockEntry.getLong(LockManager.SEQUENCE)).toDocument(), true).setReadPreference(EReadPreference.PRIMARY).maxTime(timeoutMillis, TimeUnit.MILLISECONDS);
            this.waiterTimedOut = false;
            this.waiter = Thread.currentThread();
            this.maxWaitMillis = timeoutMillis;
            this.waitingSinceNanos = System.nanoTime();
            LockManager.this.localLocksWaiting.add(this);
            try {
                if (cur.hasNext()) {
                    boolean bl = null != cur.next();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (PersistenceException.CursorNotFound ex) {
                boolean bl = false;
                return bl;
            }
            catch (PersistenceException.ExecutionTimeout ex) {
                boolean bl = false;
                return bl;
            }
            catch (PersistenceException.Interrupted ex) {
                if (this.waiterTimedOut) {
                    boolean bl = false;
                    return bl;
                }
                throw new InterruptedException();
            }
            finally {
                this.waiter = null;
                this.waiterTimedOut = false;
                LockManager.this.localLocksWaiting.remove(this);
                cur.close();
            }
        }
    }
}

