/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.provider.ps;

import com.ibm.neo.wrangler.api.DAtomicInt;
import com.ibm.neo.wrangler.api.WranglerException;
import com.ibm.neo.wrangler.provider.ps.AtomicCounters;

class PSDAtomicInt
implements DAtomicInt {
    private final AtomicCounters counters;
    private final String name;

    PSDAtomicInt(AtomicCounters counters, String name) {
        this.counters = counters;
        this.name = name;
    }

    public boolean initialize(int value) throws WranglerException {
        return this.counters.initialize(this.name, value);
    }

    public int get() throws WranglerException {
        return (int)this.counters.get(this.name);
    }

    public void set(int value) throws WranglerException {
        this.counters.set(this.name, value);
    }

    public boolean compareAndSet(int expected, int value) throws WranglerException {
        return this.counters.compareAndSet(this.name, expected, value);
    }

    public int increment() throws WranglerException {
        return (int)this.counters.change(this.name, 1L);
    }

    public int decrement() throws WranglerException {
        return (int)this.counters.change(this.name, -1L);
    }

    public int add(int delta) throws WranglerException {
        return (int)this.counters.change(this.name, delta);
    }

    public int subtract(int delta) throws WranglerException {
        return (int)this.counters.change(this.name, -delta);
    }

    public void delete() throws WranglerException {
        this.counters.delete(this.name);
    }
}

