/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.provider.ps;

import com.ibm.neo.wrangler.api.DAtomicLong;
import com.ibm.neo.wrangler.api.WranglerException;
import com.ibm.neo.wrangler.provider.ps.AtomicCounters;

class PSDAtomicLong
implements DAtomicLong {
    private final AtomicCounters counters;
    private final String name;

    PSDAtomicLong(AtomicCounters counters, String name) {
        this.counters = counters;
        this.name = name;
    }

    public boolean initialize(long value) throws WranglerException {
        return this.counters.initialize(this.name, value);
    }

    public long get() throws WranglerException {
        return this.counters.get(this.name);
    }

    public void set(long value) throws WranglerException {
        this.counters.set(this.name, value);
    }

    public boolean compareAndSet(long expected, long value) throws WranglerException {
        return this.counters.compareAndSet(this.name, expected, value);
    }

    public long increment() throws WranglerException {
        return this.counters.change(this.name, 1L);
    }

    public long decrement() throws WranglerException {
        return this.counters.change(this.name, -1L);
    }

    public long add(long delta) throws WranglerException {
        return this.counters.change(this.name, delta);
    }

    public long subtract(long delta) throws WranglerException {
        return this.counters.change(this.name, -delta);
    }

    public void delete() throws WranglerException {
        this.counters.delete(this.name);
    }
}

