/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.provider.ps;

import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.wrangler.api.DAtomicInt;
import com.ibm.neo.wrangler.api.DAtomicLong;
import com.ibm.neo.wrangler.api.DGroupMember;
import com.ibm.neo.wrangler.api.DLeaderLatch;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerException;
import com.ibm.neo.wrangler.api.WranglerProvider;
import com.ibm.neo.wrangler.provider.ps.AtomicCounters;
import com.ibm.neo.wrangler.provider.ps.GroupManager;
import com.ibm.neo.wrangler.provider.ps.LeaderManager;
import com.ibm.neo.wrangler.provider.ps.LockManager;
import com.ibm.neo.wrangler.provider.ps.PSDAtomicInt;
import com.ibm.neo.wrangler.provider.ps.PSDAtomicLong;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSWranglerProvider
implements WranglerProvider {
    private static final String COORDINATION_DB_NAME = "coordination";
    private static final Logger LOGGER = LoggerFactory.getLogger(PSWranglerProvider.class);
    private LockManager lockManager;
    private LeaderManager leaderManager;
    private GroupManager groupManager;
    private AtomicCounters counters;

    public void initialize(Properties config) throws WranglerException {
        LOGGER.info("Initializing PSWranglerProvider");
        try {
            PersistenceService ps = PersistenceService.getInstance();
            IDocumentDatabase coordinationDb = ps.getDatabase(COORDINATION_DB_NAME);
            this.lockManager = new LockManager(coordinationDb);
            this.leaderManager = new LeaderManager(this.lockManager);
            this.groupManager = new GroupManager(coordinationDb);
            this.counters = new AtomicCounters(coordinationDb);
        }
        catch (PersistenceException ex) {
            LOGGER.error("Error caught while initializing", (Throwable)ex);
            throw new WranglerException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        LOGGER.info("Terminating PSWranglerProvider");
        try {
            this.leaderManager.dispose();
        }
        catch (Exception ex) {
            LOGGER.error("Error caught while terminating", (Throwable)ex);
        }
        finally {
            this.leaderManager = null;
        }
        try {
            this.lockManager.dispose();
        }
        catch (Exception ex) {
            LOGGER.error("Error caught while terminating", (Throwable)ex);
        }
        finally {
            this.lockManager = null;
        }
        try {
            this.groupManager.dispose();
        }
        catch (Exception ex) {
            LOGGER.error("Error caught while terminating", (Throwable)ex);
        }
        finally {
            this.groupManager = null;
        }
        this.counters = null;
    }

    public DLock getDLock(String name) throws WranglerException {
        return this.lockManager.createLock(name);
    }

    public DAtomicInt getDAtomicInt(String name) throws WranglerException {
        return new PSDAtomicInt(this.counters, name);
    }

    public DAtomicLong getDAtomicLong(String name) throws WranglerException {
        return new PSDAtomicLong(this.counters, name);
    }

    public DLeaderLatch getDLeaderLatch(String name) throws WranglerException {
        return this.leaderManager.createLeaderLatch(name);
    }

    public DGroupMember getDGroupMember(String group, String thisId, byte[] thisData) throws WranglerException {
        return this.groupManager.createGroupMember(group, thisId, thisData);
    }
}

