/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.Token;

abstract class Lexer {
    private static final char DISABLED = '\ufffe';
    private final char delimiter;
    private final char escape;
    private final char quoteChar;
    private final char commmentStart;
    final boolean ignoreSurroundingSpaces;
    final boolean ignoreEmptyLines;
    final CSVFormat format;
    final ExtendedBufferedReader in;

    Lexer(CSVFormat format, ExtendedBufferedReader in) {
        this.format = format;
        this.in = in;
        this.delimiter = format.getDelimiter();
        this.escape = this.mapNullToDisabled(format.getEscape());
        this.quoteChar = this.mapNullToDisabled(format.getQuoteChar());
        this.commmentStart = this.mapNullToDisabled(format.getCommentStart());
        this.ignoreSurroundingSpaces = format.getIgnoreSurroundingSpaces();
        this.ignoreEmptyLines = format.getIgnoreEmptyLines();
    }

    private final char mapNullToDisabled(Character c) {
        return c == null ? (char)'\ufffe' : (char)c.charValue();
    }

    long getCurrentLineNumber() {
        return this.in.getCurrentLineNumber();
    }

    long getCurrentOffset() {
        return this.in.offset();
    }

    int readEscape() throws IOException {
        int c = this.in.read();
        switch (c) {
            case 114: {
                return 13;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 98: {
                return 8;
            }
            case 102: {
                return 12;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                return c;
            }
            case -1: {
                throw new IOException("EOF whilst processing escape sequence");
            }
        }
        if (this.isMetaChar(c)) {
            return c;
        }
        return -1;
    }

    void trimTrailingSpaces(StringBuilder buffer) {
        int length;
        for (length = buffer.length(); length > 0 && Character.isWhitespace(buffer.charAt(length - 1)); --length) {
        }
        if (length != buffer.length()) {
            buffer.setLength(length);
        }
    }

    boolean readEndOfLine(int c) throws IOException {
        if (c == 13 && this.in.lookAhead() == 10) {
            c = this.in.read();
        }
        return c == 10 || c == 13;
    }

    abstract Token nextToken(Token var1) throws IOException;

    boolean isWhitespace(int c) {
        return !this.isDelimiter(c) && Character.isWhitespace((char)c);
    }

    boolean isStartOfLine(int c) {
        return c == 10 || c == 13 || c == -2;
    }

    boolean isEndOfFile(int c) {
        return c == -1;
    }

    boolean isDelimiter(int c) {
        return c == this.delimiter;
    }

    boolean isEscape(int c) {
        return c == this.escape;
    }

    boolean isQuoteChar(int c) {
        return c == this.quoteChar;
    }

    boolean isCommentStart(int c) {
        return c == this.commmentStart;
    }

    private boolean isMetaChar(int c) {
        return c == this.delimiter || c == this.escape || c == this.quoteChar || c == this.commmentStart;
    }
}

