/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.builder;

import com.ibm.bi.platform.moser.common.generated.daas.Jdbc;
import com.ibm.bi.platform.moser.common.generated.daas.Module;
import com.ibm.bi.platform.moser.common.generated.daas.Source;
import com.ibm.bi.platform.moser.common.generated.daas.Table;
import com.ibm.bi.platform.moser.common.generated.daas.TaxonomyFamilyType;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class ConverterDaasModule2Module {
    private static final Set<TaxonomyFamilyType> GEOLOCATION = new HashSet<TaxonomyFamilyType>(Arrays.asList(TaxonomyFamilyType.C_CITY, TaxonomyFamilyType.C_CONTINENT, TaxonomyFamilyType.C_COUNTRY, TaxonomyFamilyType.C_LATITUDE, TaxonomyFamilyType.C_LONGITUDE, TaxonomyFamilyType.C_POSITION, TaxonomyFamilyType.C_POSTAL_CODE, TaxonomyFamilyType.C_REGION, TaxonomyFamilyType.C_STATE_PROVINCE, TaxonomyFamilyType.C_STREET_ADDRESS, TaxonomyFamilyType.C_SUB_CONTINENT));
    private static final Set<TaxonomyFamilyType> TIME = new HashSet<TaxonomyFamilyType>(Arrays.asList(TaxonomyFamilyType.C_DATE, TaxonomyFamilyType.C_DAY, TaxonomyFamilyType.C_HOUR, TaxonomyFamilyType.C_MINUTE, TaxonomyFamilyType.C_MONTH, TaxonomyFamilyType.C_QUARTER, TaxonomyFamilyType.C_SEASON, TaxonomyFamilyType.C_SECOND, TaxonomyFamilyType.C_WEEK, TaxonomyFamilyType.C_YEAR));

    public com.ibm.bi.platform.moser.common.generated.metadata.Module convert(Module simple) {
        com.ibm.bi.platform.moser.common.generated.metadata.Module ret = new com.ibm.bi.platform.moser.common.generated.metadata.Module();
        ret.setVersion("11.1");
        ret.setIdentifier(simple.getIdentifier());
        ret.setLabel(simple.getLabel());
        ConverterDaasModule2Module.processSource(simple.getSource(), ret);
        ConverterDaasModule2Module.processTable(simple.getTable(), ret);
        return ret;
    }

    private static void processTable(Table table, com.ibm.bi.platform.moser.common.generated.metadata.Module ret) {
        DataSource ds = (DataSource)ret.getDataSource().get(0);
        com.ibm.bi.platform.moser.common.generated.metadata.Table tbl = new com.ibm.bi.platform.moser.common.generated.metadata.Table();
        QuerySubject qs = new QuerySubject();
        String value = table.getName();
        tbl.setName(value);
        qs.getRef().add(0, value);
        qs.setIdentifier(IdentifierUtil.makeUniqueAndValidIdentifier((String)value, (CaseInsensitiveMap)new CaseInsensitiveMap()));
        qs.setLabel(value);
        value = table.getDescription();
        tbl.setDescription(value);
        qs.setDescription(value);
        CaseInsensitiveMap uniqueIds = new CaseInsensitiveMap();
        for (com.ibm.bi.platform.moser.common.generated.daas.Column column : table.getColumn()) {
            Column col = new Column();
            QueryItem qi = new QueryItem();
            value = column.getDatatype();
            col.setDatatype(value);
            qi.setDatatype(value);
            value = column.getDescription();
            col.setDescription(value);
            qi.setDescription(value);
            value = column.getName();
            col.setName(value);
            String identifier = IdentifierUtil.makeUniqueAndValidIdentifier((String)value, (CaseInsensitiveMap)uniqueIds);
            uniqueIds.put((Object)identifier, (Object)Boolean.TRUE);
            qi.setIdentifier(identifier);
            qi.setExpression(value);
            col.setNullable(column.isNullable());
            qi.setNullable(column.isNullable());
            qi.setLabel(column.getLabel());
            qi.setUsage(UsageType.fromValue((String)column.getUsage().value()));
            qi.setRegularAggregate(RegularAggregateType.fromValue((String)column.getRegularAggregate().value()));
            if (null != column.getTaxonomyFamily()) {
                qi.addTaxonomy(ConverterDaasModule2Module.convertTaxonomy(column.getTaxonomyFamily()));
            }
            TableItemType tblIt = new TableItemType();
            tblIt.setColumn(col);
            tbl.addTableItem(tblIt);
            ItemType it = new ItemType();
            it.setQueryItem(qi);
            qs.addItem(it);
        }
        ds.getTable().add(tbl);
        ret.getQuerySubject().add(qs);
    }

    private static TaxonomyType convertTaxonomy(TaxonomyFamilyType src) {
        TaxonomyType taxonomy = new TaxonomyType();
        taxonomy.setDomain("cognos");
        if (TaxonomyFamilyType.C_NONE == src) {
            taxonomy.setClazz(src.value());
        } else if (GEOLOCATION.contains(src)) {
            taxonomy.setClazz("cGeoLocation");
        } else if (TIME.contains(src)) {
            taxonomy.setClazz("cTime");
        } else {
            taxonomy.setClazz(TaxonomyFamilyType.C_NONE.value());
        }
        taxonomy.setFamily(src.value());
        return taxonomy;
    }

    private static void processSource(Source source, com.ibm.bi.platform.moser.common.generated.metadata.Module ret) {
        DataSource ds = new DataSource();
        ds.setUser(source.getUser());
        ds.setPassword(source.getPassword());
        if (null != source.getSrcUrl()) {
            ds.setCsvUrl(source.getSrcUrl().getSourceUrl());
            List prop = source.getSrcUrl().getProperty();
            if (null != prop) {
                ConverterDaasModule2Module.convertProperties(prop, ret);
            }
        } else if (null != source.getJdbc()) {
            Jdbc jdbc = source.getJdbc();
            ds.setCatalog(jdbc.getCatalog());
            ds.setSchema(jdbc.getSchema());
            com.ibm.bi.platform.moser.common.generated.metadata.Jdbc jdbcMoser = new com.ibm.bi.platform.moser.common.generated.metadata.Jdbc();
            jdbcMoser.setJdbcUrl(jdbc.getJdbcUrl());
            jdbcMoser.setConnectionProperties(jdbc.getConnectionProperties());
            jdbcMoser.setDriverClassName(jdbc.getDriverClassName());
            ds.setJdbc(jdbcMoser);
        } else {
            throw new IllegalArgumentException("Module source is of unknown type.");
        }
        ret.getDataSource().add(ds);
    }

    private static void convertProperties(List<com.ibm.bi.platform.moser.common.generated.daas.PropertyType> prop, com.ibm.bi.platform.moser.common.generated.metadata.Module module) {
        for (com.ibm.bi.platform.moser.common.generated.daas.PropertyType current : prop) {
            PropertyType obj = new PropertyType();
            obj.setName(current.getName());
            obj.setValue(current.getValue());
            module.addProperty(obj);
        }
    }
}

