/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.daas.rs.endpoints;

import com.ibm.bi.platform.moser.daas.rs.endpoints.handlers.ModulesHandlerDaaS;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONObject;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="")
@Api(value="URL modules", description="Rest API to get modules using URL as identifier")
public class ModulesUrl {
    @Context
    protected HttpServletRequest httpServletRequest;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get module", response=Object.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Module not found")})
    public Object getModule(@ApiParam(value="AttributeId", required=true) @QueryParam(value="moduleUrl") String moduleUrl, @HeaderParam(value="X-XQE") @DefaultValue(value="") String query) {
        return new ModulesHandlerDaaS(new RESTClientConfig(this.httpServletRequest)).getModule(moduleUrl, query);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Posts a module.", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Module Exists")})
    public Response postModule(@ApiParam(value="Module Definition", required=true) String module) {
        return new ModulesHandlerDaaS(new RESTClientConfig(this.httpServletRequest)).postModule(module);
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update module.", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Module already exists")})
    public Object putModule(@ApiParam(value="Module URL", required=true) @QueryParam(value="moduleUrl") String moduleUrl, @ApiParam(value="Module Definition", required=true) String module) {
        return new ModulesHandlerDaaS(new RESTClientConfig(this.httpServletRequest)).putModule(moduleUrl, module);
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a module.", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=206, message="No Content"), @ApiResponse(code=404, message="Module not found")})
    public Object deleteModule(@ApiParam(value="AttributeId", required=true) @QueryParam(value="moduleUrl") String moduleUrl) {
        return new ModulesHandlerDaaS(new RESTClientConfig(this.httpServletRequest)).deleteModule(moduleUrl);
    }

    @POST
    @Path(value="/feedbackCalculation")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Expression validation request.", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Validated."), @ApiResponse(code=400, message="Invalid expression."), @ApiResponse(code=500, message="Internal Server error.")})
    public Response postFeedbackCalculation(@ApiParam(value="Module URL", required=true) @QueryParam(value="moduleUrl") String moduleUrl, @ApiParam(value="id", required=false) @QueryParam(value="id") String id, @ApiParam(value="Expression", required=true) JSONObject expression, @ApiParam(value="Connection Specification. {\"connections\":[{\"datasource\":\"GOSALES\",\"connection\":\"gosales\", \"signon\": \"usr2\"}]", required=false) @QueryParam(value="connectionSpec") String connectionSpec) {
        return new ModulesHandlerDaaS(new RESTClientConfig(this.httpServletRequest)).validateExpression(moduleUrl, id, expression, connectionSpec);
    }

    @GET
    @Path(value="/feedback")
    @Produces(value={"application/json"})
    @ApiOperation(value="Return feedback for module", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Validated."), @ApiResponse(code=404, message="Module not found"), @ApiResponse(code=500, message="Internal Server error.")})
    public Object getModuleFeedback(@ApiParam(value="Module URL", required=true) @QueryParam(value="moduleUrl") String moduleUrl, @ApiParam(value="Connection Specification. {\"connections\":[{\"datasource\":\"GOSALES\",\"connection\":\"gosales\", \"signon\": \"usr2\"}]", required=false) @QueryParam(value="connectionSpec") String connectionSpec) {
        return new ModulesHandlerDaaS(new RESTClientConfig(this.httpServletRequest)).validateExpressions(moduleUrl, connectionSpec);
    }
}

