/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.daas.rs.endpoints.handlers;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.ma.MAResponseGenerator;
import com.ibm.bi.platform.moser.core.ma.MoserXQERestClient;
import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.util.LogicalModuleResolver;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.daas.core.module.ModuleObjectManagerDaaS;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.ws.rs.core.Response;

public class ModulesHandlerDaaS {
    public static final String URL_TEMP_STORAGE = "v1/temp/";
    private static final String LOCATION = "location";
    public static final String SERVICE_PREFIX_ENV = "SERVICE_PREFIX";
    private static final int STATUS_CREATED = Response.Status.CREATED.getStatusCode();
    RESTClientConfig config;
    Locale locale = new Locale("en");
    RESTClientFactory factory = RESTClientFactory.getInstance();

    public ModulesHandlerDaaS(RESTClientConfig config) {
        this.config = config;
    }

    public void setClientFactory(RESTClientFactory factory) {
        this.factory = factory;
    }

    public Object getModule(String assetId, String query) {
        try {
            ModuleObjectManagerDaaS mm = this.getModuleManager(null);
            Module module = mm.getBaseModule(assetId, UseSpecType.URL);
            if (null == module) {
                return this.generateModuleNotFoundResponse(assetId);
            }
            if (!"query".equals(query)) {
                Module resolvedModule = ModulesHandlerDaaS.resolveShapingModule(module, mm);
                resolvedModule = ModulesHandlerDaaS.prepareForVisualization(resolvedModule);
                return Response.ok((Object)resolvedModule, (String)"application/json").lastModified(new Date()).tag(Integer.toString(resolvedModule.hashCode())).build();
            }
            return this.resolveModuleXQE(assetId, module, mm);
        }
        catch (Exception e) {
            return this.buildErrorResponseWithLogging(e, e.getLocalizedMessage());
        }
    }

    public Module resolveModule(String module, ModuleObjectManagerDaaS mm) {
        Module shapingModule = (Module)new JSONCodec().decode(Module.class, module);
        return ModulesHandlerDaaS.resolveShapingModule(shapingModule, mm);
    }

    private static Module resolveShapingModule(Module shapingModule, ModuleObjectManagerDaaS mm) {
        if (shapingModule.basicGetMetadataTreeView() != null) {
            shapingModule.basicGetMetadataTreeView().clear();
        }
        return LogicalModuleResolver.resolveLogicalModule((IModuleObjectManager)mm, (Module)shapingModule);
    }

    private Response resolveModuleXQE(String moduleId, Module embedded, IModuleObjectManager mm) {
        LinkedHashMap<String, Module> subModules = new LinkedHashMap<String, Module>();
        Module topModule = LogicalModuleResolver.resolveLogicalModuleXQE((IModuleObjectManager)mm, (String)moduleId, (Module)embedded, subModules, null, null);
        if (topModule != null) {
            subModules.put(moduleId + ".topmodule", topModule);
            LoggerAdapter.trace((Object)this, (String)"Got modules XQE '{}'. Returning status 200", (Object[])new Object[]{topModule.getIdentifier()});
            Response.ResponseBuilder builder = Response.ok(subModules, (String)"application/json");
            builder = builder.lastModified(new Date()).tag(Integer.toString(topModule.hashCode()));
            return builder.build();
        }
        return MoserUtil.getResponse((Response.Status)Response.Status.NOT_FOUND, (IMessageKey.Param1)MoserError.MSR_MODULE_NOT_FOUND, (Locale)this.locale, (String)moduleId);
    }

    private static Module prepareForVisualization(Module module) {
        if (module.basicGetDataSource() != null) {
            module.basicGetDataSource().clear();
        }
        return ModulesHandlerDaaS.processMetadataRequest(module);
    }

    private static Module processMetadataRequest(Module module) {
        if (module.basicGetMetadataTreeView() == null || module.basicGetMetadataTreeView().isEmpty()) {
            String moduleId = module.getIdentifier();
            MAResponseGenerator ma = new MAResponseGenerator(null, true);
            return ma.getMAResponse(moduleId, module, Collections.emptyList());
        }
        return module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object deleteModule(String moduleUrl) {
        try (RESTClient client = this.factory.getClient(this.config);){
            int httpCode = client.deleteResource(moduleUrl, "application/json");
            Response response = Response.status((int)httpCode).build();
            return response;
        }
        catch (Exception e) {
            return this.buildErrorResponseWithLogging(e, e.getLocalizedMessage());
        }
    }

    private static String getMetadataRequestURL(String relUrl) {
        if (System.getProperties().containsKey(SERVICE_PREFIX_ENV)) {
            return (String)System.getProperties().get(SERVICE_PREFIX_ENV) + relUrl;
        }
        return relUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response postModule(String module) {
        String moserModule;
        try {
            moserModule = ModuleObjectManagerDaaS.replaceSimpleModule(module);
        }
        catch (MoserException e) {
            e.setHTTPStatus(Response.Status.BAD_REQUEST.getStatusCode());
            return this.handleMoserException(e);
        }
        catch (Exception e) {
            return this.buildErrorResponseWithLogging(e, e.getLocalizedMessage());
        }
        try (RESTClient client = this.factory.getClient(this.config);
             ByteArrayInputStream resourceStream = new ByteArrayInputStream(moserModule.getBytes(StandardCharsets.UTF_8));){
            String url = ModulesHandlerDaaS.getMetadataRequestURL(URL_TEMP_STORAGE);
            int httpCode = client.createResource(url, "application/json", -1L, (InputStream)resourceStream);
            if (httpCode != STATUS_CREATED) {
                Response response = this.buildErrorResponseWithLogging(null, "Failed to create module at: " + url + ". Status: " + httpCode);
                return response;
            }
            String id = new RESTClientResponse(STATUS_CREATED, client).getResponseHeader(LOCATION);
            return this.resolveModule(moserModule, id);
        }
        catch (Exception e) {
            return this.buildErrorResponseWithLogging(e, e.getLocalizedMessage());
        }
    }

    private Response resolveModule(String moserModule, String id) {
        try {
            ModuleObjectManagerDaaS mm = this.getModuleManager(moserModule);
            Module shapingModule = mm.getTopModule();
            Module resolvedModule = shapingModule == null ? this.resolveModule(moserModule, mm) : ModulesHandlerDaaS.resolveShapingModule(shapingModule, mm);
            ModulesHandlerDaaS.prepareForVisualization(resolvedModule);
            return Response.status((int)STATUS_CREATED).header(LOCATION, (Object)id).entity((Object)resolvedModule).build();
        }
        catch (MoserException e) {
            return this.buildErrorResponseWithLogging((Exception)((Object)e), e.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object putModule(String moduleUrl, String module) {
        String moserModule;
        try {
            moserModule = ModuleObjectManagerDaaS.replaceSimpleModule(module);
        }
        catch (MoserException e) {
            e.setHTTPStatus(Response.Status.BAD_REQUEST.getStatusCode());
            return this.handleMoserException(e);
        }
        catch (Exception e) {
            return this.buildErrorResponseWithLogging(e, e.getLocalizedMessage());
        }
        try (RESTClient client = this.factory.getClient(this.config);
             ByteArrayInputStream resourceStream = new ByteArrayInputStream(moserModule.getBytes(StandardCharsets.UTF_8));){
            int httpCode = client.updateResource(moduleUrl, "application/json", -1L, (InputStream)resourceStream);
            if (httpCode != Response.Status.NO_CONTENT.getStatusCode() && httpCode != Response.Status.OK.getStatusCode() && httpCode != Response.Status.CREATED.getStatusCode()) {
                Response response = this.buildErrorResponseWithLogging(null, "Failed to update module: " + moduleUrl + " Status: " + httpCode);
                return response;
            }
        }
        catch (Exception e) {
            return this.buildErrorResponseWithLogging(e, e.getLocalizedMessage());
        }
        try {
            ModuleObjectManagerDaaS mm = this.getModuleManager(moserModule);
            Module shapingModule = mm.getTopModule();
            Module resolvedModule = shapingModule == null ? this.resolveModule(moserModule, mm) : ModulesHandlerDaaS.resolveShapingModule(shapingModule, mm);
            ModulesHandlerDaaS.prepareForVisualization(resolvedModule);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)resolvedModule).build();
        }
        catch (MoserException e) {
            return this.buildErrorResponseWithLogging((Exception)((Object)e), e.getLocalizedMessage());
        }
    }

    public Response validateExpression(String moduleUrl, String objectId, JSONObject expression, String connectionSpec) {
        return new MoserXQERestClient(this.config, this.factory).validateExpression(moduleUrl, objectId, expression, connectionSpec);
    }

    private Response buildErrorResponseWithLogging(Exception e, String err) {
        LoggerAdapter.error((Object)this, (String)err);
        if (e != null) {
            LoggerAdapter.errorExceptionStack((Object)this, (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)err).build();
    }

    protected Response handleMoserException(MoserException me) {
        LoggerAdapter.errorExceptionStack((Object)this, (Throwable)me);
        return me.getResponse(this.locale);
    }

    protected Response handleException(Response.Status status, Message message, Throwable e) {
        LoggerAdapter.errorExceptionStack((Object)this, (Throwable)e);
        return MoserUtil.getResponse((Response.Status)status, (Message)message, (Locale)this.locale, (Throwable)e);
    }

    public Response validateExpressions(String moduleUrl, String connectionSpec) {
        long startTime = System.currentTimeMillis();
        try {
            ModuleObjectManagerDaaS mm = this.getModuleManager(null);
            Module module = mm.getBaseModule(moduleUrl, UseSpecType.URL);
            if (null == module) {
                return this.generateModuleNotFoundResponse(moduleUrl);
            }
            Module resolvedModule = ModulesHandlerDaaS.resolveShapingModule(module, mm);
            if (resolvedModule == null) {
                return this.generateModuleNotFoundResponse(moduleUrl);
            }
            JSONObject json = mm.validateModule(resolvedModule, moduleUrl, startTime);
            return MoserUtil.getResponse((Response.Status)Response.Status.OK, (Object)json);
        }
        catch (MoserException e) {
            return this.handleMoserException(e);
        }
        catch (Exception e) {
            return this.handleException(Response.Status.INTERNAL_SERVER_ERROR, new Message(MoserError.MSR_IE_MODULE_GET_FEEDBACK, (Object)moduleUrl), e);
        }
    }

    private Response generateModuleNotFoundResponse(String moduleUrl) {
        return MoserUtil.getResponse((Response.Status)Response.Status.NOT_FOUND, (Message)new Message(MoserError.MODULE_NOT_FOUND_ERROR, (Object)moduleUrl), (Locale)this.locale);
    }

    public ModuleObjectManagerDaaS getModuleManager(String module) {
        return new ModuleObjectManagerDaaS(this.config, this.factory, module);
    }
}

