/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n;

import com.cognos.i18n.ToolkitResources;
import java.util.ArrayList;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ResourceXMLDataHandler
extends DefaultHandler
implements ElementHandler {
    private boolean m_insideTimeZoneElement = false;
    private boolean m_insideLocaleElement = false;
    private boolean m_insideLangLocElement = false;
    private boolean m_insideLCIDToISOCodeElement = false;
    private boolean m_insideISOToSymbolCodeElement = false;
    private final String m_localeElement = new String("locale");
    private final String m_timeZoneElement = new String("timezone");
    private final String m_langLocElement = new String("langLocMappingTable");
    private final String m_LCIDToISOCodeElement = new String("LCIDtoCurrencyCodeMappingTable");
    private final String m_ISOToSymbolCodeElement = new String("ISOCurrencyCodetoSymbolMappingTable");
    private final String m_EntryElement = new String("entry");
    private boolean m_differentCharacterCall = false;
    private String m_PrevCharacters = null;
    private String m_localeLCID = null;
    private boolean m_isRTLAttr = false;
    private Character m_zeroDigit = null;
    private String m_decimalSeparator = null;
    private String m_listSeparator = null;
    private String m_groupingSeparator = null;

    ResourceXMLDataHandler() {
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        super.warning(e);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.m_differentCharacterCall = false;
        if (name.compareTo(this.m_timeZoneElement) == 0) {
            this.m_insideTimeZoneElement = true;
            return;
        }
        if (name.compareTo(this.m_localeElement) == 0) {
            String groupingSeparator;
            String listSeparator;
            String decimalSeparator;
            String zeroDigit;
            String isRTLAttr;
            this.m_insideLocaleElement = true;
            this.m_localeLCID = attributes.getValue("lcid");
            if (this.m_localeLCID == null) {
                this.m_localeLCID = "";
            }
            if ((isRTLAttr = attributes.getValue("isRTL")) != null) {
                this.m_isRTLAttr = Boolean.parseBoolean(isRTLAttr);
            }
            if ((zeroDigit = attributes.getValue("zeroDigit")) != null) {
                int x = Integer.parseInt(zeroDigit, 16);
                this.m_zeroDigit = Character.valueOf((char)x);
            }
            if ((decimalSeparator = attributes.getValue("decimalSeparator")) != null) {
                this.m_decimalSeparator = decimalSeparator;
            }
            if ((listSeparator = attributes.getValue("listSeparator")) != null) {
                this.m_listSeparator = listSeparator;
            }
            if ((groupingSeparator = attributes.getValue("groupingSeparator")) != null) {
                this.m_groupingSeparator = groupingSeparator;
            }
            return;
        }
        if (name.compareTo(this.m_langLocElement) == 0) {
            this.m_insideLangLocElement = true;
            return;
        }
        if (name.compareTo(this.m_LCIDToISOCodeElement) == 0) {
            this.m_insideLCIDToISOCodeElement = true;
            return;
        }
        if (name.compareTo(this.m_ISOToSymbolCodeElement) == 0) {
            this.m_insideISOToSymbolCodeElement = true;
            return;
        }
        if (name.compareTo(this.m_EntryElement) == 0) {
            String attrValue;
            String attrKey;
            if (this.m_insideLCIDToISOCodeElement) {
                attrKey = attributes.getValue(0);
                attrValue = attributes.getValue(1);
                if (attrKey != null && attrValue != null) {
                    ToolkitResources.m_LCIDToISO.put(attrKey, attrValue);
                }
            }
            if (this.m_insideLangLocElement) {
                attrKey = attributes.getValue(0);
                attrValue = attributes.getValue(1);
                if (attrKey != null && attrValue != null) {
                    ToolkitResources.m_langToDefaultLocaleMap.put(attrKey, attrValue);
                }
            }
            if (this.m_insideISOToSymbolCodeElement) {
                attrKey = attributes.getValue(0);
                attrValue = attributes.getValue(1);
                if (attrKey != null && attrValue != null) {
                    ToolkitResources.m_currncySymbolsMap.put(attrKey, attrValue);
                }
            }
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.compareTo(this.m_timeZoneElement) == 0) {
            this.m_insideTimeZoneElement = false;
            return;
        }
        if (name.compareTo(this.m_localeElement) == 0) {
            this.m_insideLocaleElement = false;
            this.m_zeroDigit = null;
            this.m_decimalSeparator = null;
            this.m_listSeparator = null;
            this.m_groupingSeparator = null;
            return;
        }
        if (name.compareTo(this.m_langLocElement) == 0) {
            this.m_insideLangLocElement = false;
            return;
        }
        if (name.compareTo(this.m_LCIDToISOCodeElement) == 0) {
            this.m_insideLCIDToISOCodeElement = false;
            return;
        }
        if (name.compareTo(this.m_ISOToSymbolCodeElement) == 0) {
            this.m_insideISOToSymbolCodeElement = false;
            return;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_insideTimeZoneElement) {
            String id = new String(ch, start, length);
            ToolkitResources.m_timeZoneIDs.add(id);
            this.m_differentCharacterCall = true;
            return;
        }
        if (this.m_insideLocaleElement) {
            String id = new String(ch, start, length);
            if (!this.m_differentCharacterCall) {
                if (this.m_isRTLAttr) {
                    ToolkitResources.m_rtlLocales.add(id);
                    this.m_isRTLAttr = false;
                }
                ToolkitResources.m_localeIDs.add(id);
                ToolkitResources.m_localeToLCID.put(id, this.m_localeLCID);
                ToolkitResources.m_LCIDToLocale.put(this.m_localeLCID, id);
                if (this.m_zeroDigit != null) {
                    ToolkitResources.m_localeZeroDigit.put(id, this.m_zeroDigit);
                }
                if (this.m_decimalSeparator != null && this.m_listSeparator != null && this.m_groupingSeparator != null) {
                    ArrayList<String> theList = new ArrayList<String>();
                    theList.add(new String(this.m_decimalSeparator));
                    theList.add(new String(this.m_listSeparator));
                    theList.add(new String(this.m_groupingSeparator));
                    ToolkitResources.m_localeSeparatorsMap.put(id, theList);
                }
            } else {
                if (this.m_isRTLAttr) {
                    ToolkitResources.m_rtlLocales.remove(this.m_PrevCharacters);
                    ToolkitResources.m_rtlLocales.add(this.m_PrevCharacters + id);
                    this.m_isRTLAttr = false;
                }
                ToolkitResources.m_localeIDs.remove(this.m_PrevCharacters);
                ToolkitResources.m_localeIDs.add(this.m_PrevCharacters + id);
                ToolkitResources.m_localeToLCID.remove(this.m_PrevCharacters);
                ToolkitResources.m_localeToLCID.put(this.m_PrevCharacters + id, this.m_localeLCID);
                ToolkitResources.m_LCIDToLocale.remove(this.m_PrevCharacters);
                ToolkitResources.m_LCIDToLocale.put(this.m_PrevCharacters + this.m_localeLCID, id);
                if (this.m_zeroDigit != null) {
                    ToolkitResources.m_localeZeroDigit.remove(this.m_PrevCharacters);
                    ToolkitResources.m_localeZeroDigit.put(this.m_PrevCharacters + id, this.m_zeroDigit);
                }
                if (this.m_decimalSeparator != null && this.m_listSeparator != null && this.m_groupingSeparator != null) {
                    ArrayList<String> theList = new ArrayList<String>();
                    theList.add(new String(this.m_decimalSeparator));
                    theList.add(new String(this.m_listSeparator));
                    theList.add(new String(this.m_groupingSeparator));
                    ToolkitResources.m_localeSeparatorsMap.remove(this.m_PrevCharacters);
                    ToolkitResources.m_localeSeparatorsMap.put(this.m_PrevCharacters + id, theList);
                }
            }
            this.m_PrevCharacters = id;
            this.m_differentCharacterCall = true;
            return;
        }
    }

    public void onEnd(ElementPath arg0) {
    }

    public void onStart(ElementPath arg0) {
    }
}

