/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n;

import com.cognos.i18n.ToolkitResources;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TimeZone {
    protected com.ibm.icu.util.TimeZone zone;
    private static int m_objCacheSize = 0;
    private static final int m_objCacheSizeCap = 1000;
    private static Map m_objCache = null;
    private static Object m_mutex = new Object();

    private static synchronized void initObjCache() {
        if (m_objCache == null) {
            m_objCache = new HashMap(12);
        }
    }

    private static void addToObjCache(com.ibm.icu.util.TimeZone tzInstance, String id) {
        if (m_objCacheSize == 1000) {
            m_objCache.clear();
            m_objCacheSize = 0;
        }
        m_objCache.put(id, tzInstance);
        ++m_objCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static com.ibm.icu.util.TimeZone getFromObjCache(String timeZoneId) {
        com.ibm.icu.util.TimeZone tzInstance = null;
        Object object = m_mutex;
        synchronized (object) {
            tzInstance = (com.ibm.icu.util.TimeZone)m_objCache.get(timeZoneId);
            if (tzInstance == null) {
                tzInstance = com.ibm.icu.util.TimeZone.getTimeZone((String)timeZoneId);
                TimeZone.addToObjCache(tzInstance, timeZoneId);
            }
            return (com.ibm.icu.util.TimeZone)tzInstance.clone();
        }
    }

    public TimeZone() {
        this.zone = com.ibm.icu.util.TimeZone.getDefault();
    }

    public TimeZone(String timeZoneId) {
        if (m_objCache == null) {
            TimeZone.initObjCache();
        }
        this.zone = TimeZone.getFromObjCache(ToolkitResources.getFallbackTimeZoneID(timeZoneId));
    }

    public String getDisplayName() {
        return this.zone.getDisplayName();
    }

    public String getDisplayName(Locale locale) {
        Locale theDefaultLocale = ToolkitResources.getDefaultLocaleForCurrentLocale(locale);
        return this.zone.getDisplayName(theDefaultLocale);
    }

    public String getID() {
        return this.zone.getID();
    }

    public Object clone() {
        TimeZone newTz = new TimeZone();
        newTz.zone = (com.ibm.icu.util.TimeZone)this.zone.clone();
        return newTz;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TimeZone)) {
            return false;
        }
        return this.zone.equals((Object)((TimeZone)obj).zone);
    }

    public int hashCode() {
        return this.zone.hashCode();
    }

    public String toString() {
        return this.zone.toString();
    }

    public static TimeZone getDefault() {
        return new TimeZone();
    }

    public static TimeZone getTimeZone(String id) {
        return new TimeZone(id);
    }

    public boolean inDaylightTime(Date date) {
        return this.zone.inDaylightTime(date);
    }

    public boolean useDaylightTime() {
        return this.zone.useDaylightTime();
    }

    public int getDSTSavings() {
        return this.zone.getDSTSavings();
    }

    public int getRawOffset() {
        return this.zone.getRawOffset();
    }
}

