/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n;

import com.cognos.i18n.ResourceXMLDataHandler;
import com.cognos.i18n.TimeZone;
import com.cognos.i18n.TimeZoneDescriptionComparator;
import com.ibm.cognos.ccl4j.util.CCLEncodingMap;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ToolkitResources {
    private static String m_defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[1])).getEncoding();
    private static boolean m_bUSE_IBM_ICU_RESOURCES = true;
    private static boolean m_resourcesLoaded = false;
    private static final int m_cacheCapacity = 3;
    private static final String I18N_CURRENCY_RES_BASE = "./ccli18nrescr_";
    private static final String I18N_TIMEZONE_RES_BASE = "./ccli18nrestz_";
    private static final String I18N_LOCALE_RES_BASE = "./ccli18nreslc_";
    private static final String I18N_WORDTRANSL_RES_BASE = "./ccli18nreswd_";
    private static String I18N_CONFIG_RES_NAME = "../configuration/i18n_res.xml";
    private static final String I18N_RES_EXT = ".xml";
    private static Map<String, Map<String, String>> m_translations = null;
    private static List<String> m_translationsFifoCache = null;
    private static final String m_noDescriptionID = "noDescription";
    private static Map<String, Map<String, String>> m_currencies = null;
    private static List<String> m_currencyFifoCache = null;
    private static Map<String, Map<String, String>> m_timeZones = null;
    private static List<String> m_tzFifoCache = null;
    static List<String> m_timeZoneIDs = null;
    private static Map<String, Map<String, String>> m_locales = null;
    private static List<String> m_localeFifoCache = null;
    static List<String> m_localeIDs = null;
    static List<String> m_rtlLocales = null;
    static Map<String, String> m_langToDefaultLocaleMap = null;
    private static final String m_defaultLang = "en";
    private static final Locale m_defaultLocale = Locale.US;
    private static final ULocale m_defaultULocale = ULocale.US;
    private static final String m_defaultTimeZoneId = TimeZone.getDefault().getID();
    private static String m_binDirectoryPath = null;
    private static Object m_mutex = new Object();
    private static final char m_dashChar = '-';
    private static final char m_dotChar = '.';
    private static final char m_underscoreChar = '_';
    private static final String m_emptyString = "";
    static Map<String, String> m_currncySymbolsMap = null;
    private static Map<String, String> m_backComaptTZ = null;
    private static Map<String, String> m_backComaptOldTZ = null;
    static Map<String, String> m_localeToLCID = null;
    static Map<String, String> m_LCIDToLocale = null;
    static Map<String, String> m_LCIDToISO = null;
    static Map<String, Character> m_localeZeroDigit = null;
    static Map<String, List<String>> m_localeSeparatorsMap = null;

    public static String getDefaultEncoding() {
        return m_defaultEncoding;
    }

    public static boolean isUseIBMicuResources() {
        return m_bUSE_IBM_ICU_RESOURCES;
    }

    public static void setReourceFileName(String fileName) {
        I18N_CONFIG_RES_NAME = fileName;
    }

    public static String normalizeEncoding(String encoding) {
        String result = CCLEncodingMap.getJava2IANAMapping((String)encoding);
        if (result == null) {
            if (CCLEncodingMap.getIANA2JavaMapping((String)encoding) != null) {
                return encoding;
            }
            return m_emptyString;
        }
        return result;
    }

    public static String getEquivalentTimeZoneID(String timeZoneID) {
        String mappedTZ;
        com.ibm.icu.util.TimeZone icuTz;
        String[] IDs;
        try {
            if (m_backComaptOldTZ == null && !m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String gmtId = "GMT";
        String tmpTimeZoneID = null;
        tmpTimeZoneID = timeZoneID.startsWith("GMT") && timeZoneID.length() > 3 ? ((IDs = com.ibm.icu.util.TimeZone.getAvailableIDs((int)(icuTz = com.ibm.icu.util.TimeZone.getTimeZone((String)timeZoneID)).getRawOffset())).length >= 1 ? ToolkitResources.getEquivalentTimeZoneID(IDs[0]) : "GMT") : ((mappedTZ = m_backComaptOldTZ.get(timeZoneID)) != null ? mappedTZ : timeZoneID);
        List<String> tzList = ToolkitResources.getTimeZones();
        if (tzList != null) {
            int count = 0;
            try {
                count = com.ibm.icu.util.TimeZone.countEquivalentIDs((String)tmpTimeZoneID);
            }
            catch (MissingResourceException e) {
                tmpTimeZoneID = "GMT";
            }
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    String sEquivalentID = com.ibm.icu.util.TimeZone.getEquivalentID((String)tmpTimeZoneID, (int)i);
                    if (!tzList.contains(sEquivalentID)) continue;
                    return sEquivalentID;
                }
            }
        }
        return tmpTimeZoneID;
    }

    public static String getFallbackTimeZoneID(String timeZoneID) {
        String fallback;
        String tzID = m_defaultTimeZoneId;
        if (timeZoneID != null && timeZoneID.length() > 0) {
            tzID = timeZoneID;
        }
        try {
            if (m_backComaptTZ == null && !m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tzID != null && (fallback = m_backComaptTZ.get(tzID)) != null) {
            return fallback;
        }
        return timeZoneID;
    }

    public static String normalizeLocaleIdentifier(String identifier) {
        StringBuffer normalizedIdentifier = new StringBuffer(identifier.toLowerCase());
        String doubleUnderscore = new String("__");
        int ind = identifier.indexOf(doubleUnderscore);
        if (ind > 0) {
            normalizedIdentifier = normalizedIdentifier.replace(ind, ind + doubleUnderscore.length(), String.valueOf('.'));
        } else {
            ind = identifier.indexOf(95);
            if (ind >= 0) {
                normalizedIdentifier = normalizedIdentifier.replace(ind, ind + 1, String.valueOf('-'));
            } else {
                ind = identifier.indexOf(45);
            }
            int indSecond = identifier.indexOf(95, ind + 1);
            if (indSecond >= 0) {
                normalizedIdentifier = normalizedIdentifier.replace(indSecond, indSecond + 1, String.valueOf('.'));
            } else {
                indSecond = identifier.indexOf(45, ind + 1);
            }
            if (ind >= 0) {
                String afterLang;
                if (indSecond < 0) {
                    indSecond = normalizedIdentifier.length();
                }
                if ((afterLang = normalizedIdentifier.substring(ind + 1, indSecond)).length() == 4) {
                    normalizedIdentifier.replace(ind, indSecond, m_emptyString);
                }
            }
        }
        return normalizedIdentifier.toString();
    }

    public static Map<String, String> getLocaleDescriptions(String languageId) {
        Map<String, String> locales = null;
        String langId = m_defaultLang;
        if (languageId != null && languageId.length() > 0) {
            langId = languageId;
        }
        try {
            if (m_locales == null) {
                if (!m_resourcesLoaded) {
                    ToolkitResources.loadResources();
                }
                ToolkitResources.loadResources(m_locales, langId, I18N_LOCALE_RES_BASE, "LOC");
                m_localeFifoCache.add(langId);
                locales = m_locales.get(langId);
            } else {
                locales = m_locales.get(langId);
                if (locales == null) {
                    if (m_locales.size() >= 3) {
                        m_locales.remove(m_localeFifoCache.get(2));
                        m_localeFifoCache.remove(2);
                    }
                    ToolkitResources.loadResources(m_locales, langId, I18N_LOCALE_RES_BASE, "LOC");
                    m_localeFifoCache.add(langId);
                    locales = m_locales.get(langId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (locales == null) {
            locales = new Hashtable<String, String>();
        }
        return Collections.unmodifiableMap(locales);
    }

    public static String getLocaleDescription(String localeId, String languageId) {
        String normLocaleID = ToolkitResources.normalizeLocaleIdentifier(localeId);
        try {
            Map<String, String> descriptions = ToolkitResources.getLocaleDescriptions(languageId);
            String description = descriptions.get(normLocaleID);
            if (description != null) {
                return description;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Locale locale = ToolkitResources.getLocaleFromStringID(localeId);
        Locale displayLocale = ToolkitResources.getLocaleFromStringID(languageId);
        if (locale.getDisplayCountry(displayLocale).toLowerCase().equals(locale.getCountry().toLowerCase()) && locale.getCountry().length() > 0 || locale.getDisplayLanguage(displayLocale).toLowerCase().equals(locale.getLanguage().toLowerCase()) && locale.getLanguage().length() > 0 || locale.getDisplayVariant(displayLocale).toLowerCase().equals(locale.getVariant().toLowerCase()) && locale.getVariant().length() > 0) {
            return ToolkitResources.normalizeLocaleIdentifier(locale.toString()) + " (" + ToolkitResources.getNoDescriptionWords(languageId) + ")";
        }
        return locale.getDisplayName(displayLocale);
    }

    public static Locale getLocaleFromStringID(String localeID) {
        String normLocaleID = ToolkitResources.normalizeLocaleIdentifier(localeID);
        int indDash = normLocaleID.indexOf(45);
        String language = m_emptyString;
        String country = m_emptyString;
        String variant = m_emptyString;
        if (indDash < 0) {
            int indDot = normLocaleID.indexOf(46);
            if (indDot >= 0) {
                language = normLocaleID.substring(0, indDot);
                variant = normLocaleID.substring(indDot + 1);
            } else {
                language = normLocaleID;
            }
        } else {
            int indDot = normLocaleID.indexOf(46, indDash + 1);
            language = normLocaleID.substring(0, indDash);
            if (indDot >= 0) {
                country = normLocaleID.substring(indDash + 1, indDot);
                variant = normLocaleID.substring(indDot + 1);
            } else {
                country = normLocaleID.substring(indDash + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static String getLocaleDescription(String localeId) {
        return ToolkitResources.getLocaleDescription(localeId, m_defaultLang);
    }

    public static List<String> getLocaleIDs() {
        return ToolkitResources.getLocales();
    }

    public static List<String> getLocales() {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m_localeIDs;
    }

    public static List<String> getRTLLocales() {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m_rtlLocales;
    }

    public static boolean validateLocaleId(String localeId) {
        List<String> list = ToolkitResources.getLocales();
        String normLocaleId = ToolkitResources.normalizeLocaleIdentifier(localeId);
        return list.contains(normLocaleId);
    }

    public static String getTimeZoneDescription(String timeZoneId, String languageId) {
        try {
            Map<String, String> descriptions = ToolkitResources.getTimeZoneDescriptions(languageId);
            String description = descriptions.get(timeZoneId);
            if (description != null) {
                return description;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeZoneId + " - " + ToolkitResources.getNoDescriptionWords(languageId);
    }

    public static String getTimeZoneDescription(String timeZoneId) {
        return ToolkitResources.getTimeZoneDescription(timeZoneId, m_defaultLang);
    }

    public static List<String> getTimeZones() {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m_timeZoneIDs;
    }

    public static Map<String, String> sortMapByValue(Map<String, String> map, Locale locale) {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(list, new TimeZoneDescriptionComparator(locale));
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public static Map<String, String> getTimeZoneDescriptions(String languageId) {
        Map<String, String> tz = null;
        String langId = m_defaultLang;
        if (languageId != null && languageId.length() > 0) {
            langId = languageId;
        }
        try {
            if (m_timeZones == null) {
                ToolkitResources.loadTimeZones(langId);
                m_tzFifoCache.add(langId);
                tz = m_timeZones.get(langId);
            } else {
                tz = m_timeZones.get(langId);
                if (tz == null) {
                    if (m_timeZones.size() >= 3) {
                        m_timeZones.remove(m_tzFifoCache.get(2));
                        m_tzFifoCache.remove(2);
                    }
                    ToolkitResources.loadTimeZones(langId);
                    m_tzFifoCache.add(langId);
                    tz = m_timeZones.get(langId);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tz == null) {
            tz = new Hashtable<String, String>();
        }
        Map<String, String> result = Collections.unmodifiableMap(ToolkitResources.sortMapByValue(tz, new Locale(langId)));
        return result;
    }

    public static Map<String, String> getCurrencyDescriptions(String languageId) {
        Map<String, String> currencies = null;
        String langId = m_defaultLang;
        if (languageId != null && languageId.length() > 0) {
            langId = languageId;
        }
        try {
            if (m_currencies == null) {
                if (!m_resourcesLoaded) {
                    ToolkitResources.loadResources();
                }
                ToolkitResources.loadResources(m_currencies, langId, I18N_CURRENCY_RES_BASE, "CRD");
                m_currencyFifoCache.add(langId);
                currencies = m_currencies.get(langId);
            } else {
                currencies = m_currencies.get(langId);
                if (currencies == null) {
                    if (m_currencies.size() >= 3) {
                        m_currencies.remove(m_currencyFifoCache.get(2));
                        m_currencyFifoCache.remove(2);
                    }
                    ToolkitResources.loadResources(m_currencies, langId, I18N_CURRENCY_RES_BASE, "CRD");
                    m_currencyFifoCache.add(langId);
                    currencies = m_currencies.get(langId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currencies == null) {
            currencies = new Hashtable<String, String>();
        }
        return Collections.unmodifiableMap(currencies);
    }

    public static String getNoDescriptionWords(String languageId) {
        String langId = m_defaultLang;
        if (languageId != null && languageId.length() > 0) {
            langId = languageId;
        }
        try {
            Map<String, String> descriptions = ToolkitResources.getWordTranslations(langId);
            String description = descriptions.get(m_noDescriptionID);
            if (description != null) {
                return description;
            }
            return "No description";
        }
        catch (Exception exception) {
            return "No description";
        }
    }

    public static Map<String, String> getWordTranslations(String languageId) {
        Map<String, String> words = null;
        String langId = m_defaultLang;
        if (languageId != null && languageId.length() > 0) {
            langId = languageId;
        }
        try {
            if (m_translations == null) {
                if (!m_resourcesLoaded) {
                    ToolkitResources.loadResources();
                }
                ToolkitResources.loadResources(m_translations, langId, I18N_WORDTRANSL_RES_BASE, "WDT");
                m_translationsFifoCache.add(langId);
                words = m_translations.get(langId);
            } else {
                words = m_translations.get(langId);
                if (words == null) {
                    if (m_translations.size() >= 3) {
                        m_translations.remove(m_translationsFifoCache.get(2));
                        m_translationsFifoCache.remove(2);
                    }
                    ToolkitResources.loadResources(m_translations, langId, I18N_WORDTRANSL_RES_BASE, "WDT");
                    m_translationsFifoCache.add(langId);
                    words = m_translations.get(langId);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (words == null) {
            words = new Hashtable<String, String>();
        }
        return Collections.unmodifiableMap(words);
    }

    public static String getCurrencyDescription(String currencyCode, String languageId) {
        String langId = m_defaultLang;
        if (languageId != null && languageId.length() > 0) {
            langId = languageId;
        }
        try {
            Map<String, String> descriptions = ToolkitResources.getCurrencyDescriptions(langId);
            String description = descriptions.get(currencyCode);
            if (description != null) {
                return description;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "(" + currencyCode + ") - " + ToolkitResources.getNoDescriptionWords(langId);
    }

    public static String getCurrencyDescription(String currencyCode) {
        return ToolkitResources.getCurrencyDescription(currencyCode, m_defaultLang);
    }

    public static Locale getDefaultLocaleForCurrentLocale(Locale locale) {
        Locale theDefaultLocale = m_defaultLocale;
        if (locale == null || locale.getLanguage().length() == 0) {
            return theDefaultLocale;
        }
        try {
            if (m_langToDefaultLocaleMap == null && !m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String theCurrentLocaleName = locale.toString();
            String theLocale = null;
            String normLocaleID = ToolkitResources.normalizeLocaleIdentifier(theCurrentLocaleName);
            if (normLocaleID != null) {
                theLocale = m_langToDefaultLocaleMap.get(normLocaleID);
            }
            if (theLocale == null || theLocale.length() <= 2) {
                theDefaultLocale = locale;
            } else {
                String normalized = ToolkitResources.normalizeLocaleIdentifier(theLocale);
                theDefaultLocale = new Locale(normalized.substring(0, 2), normalized.substring(3, 5));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theDefaultLocale;
    }

    public static String getDefaultLocaleForCurrentLocale(String language) {
        String theDefaultLocale = m_defaultLocale.toString();
        if (language == null || language.length() == 0) {
            return theDefaultLocale;
        }
        try {
            if (m_langToDefaultLocaleMap == null && !m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String theLocale = null;
            String normLocaleID = ToolkitResources.normalizeLocaleIdentifier(language);
            if (normLocaleID != null) {
                theLocale = m_langToDefaultLocaleMap.get(normLocaleID);
            }
            if (theLocale == null || theLocale.length() <= 2) {
                theDefaultLocale = language;
            } else {
                String normalized = ToolkitResources.normalizeLocaleIdentifier(theLocale);
                theDefaultLocale = normalized.substring(0, 2) + '-' + normalized.substring(3, 5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theDefaultLocale;
    }

    public static ULocale getICUDefaultLocaleForCurrentLocale(String localeID) {
        ULocale theDefaultLocale = m_defaultULocale;
        if (localeID == null || localeID.length() == 0) {
            return theDefaultLocale;
        }
        try {
            if (m_langToDefaultLocaleMap == null && !m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String theLocale = null;
            String normLocaleID = ToolkitResources.normalizeLocaleIdentifier(localeID);
            if (normLocaleID != null) {
                theLocale = m_langToDefaultLocaleMap.get(normLocaleID);
            }
            theDefaultLocale = theLocale != null ? new ULocale(theLocale) : new ULocale(localeID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theDefaultLocale;
    }

    public static ULocale getDefaultLocaleForCurrentLocale(ULocale locale) {
        ULocale theDefaultLocale = m_defaultULocale;
        if (locale == null || locale.getLanguage().length() == 0) {
            return theDefaultLocale;
        }
        return ToolkitResources.getICUDefaultLocaleForCurrentLocale(locale.getName());
    }

    public static synchronized boolean loadResources(Map<String, Map<String, String>> result, String languageId, String resourceBaseName, String sectionName) throws Exception {
        if (!m_resourcesLoaded) {
            ToolkitResources.loadResources();
        }
        String langId = null;
        langId = languageId == null || languageId.length() == 0 ? m_defaultLang : languageId;
        File file = ToolkitResources.findResourceFile(langId, resourceBaseName);
        if (file != null) {
            SAXReader reader = new SAXReader();
            Document document = reader.read(file);
            Element resources = document.getRootElement();
            List descrElements = resources.selectNodes("/stringTable/component[@name='CCL']/section[@name='" + sectionName + "']/*");
            if (descrElements != null) {
                String idText = null;
                String descrText = null;
                TreeMap<String, String> idToDescr = new TreeMap<String, String>();
                Iterator i = descrElements.iterator();
                Element descrElement = null;
                while (i.hasNext()) {
                    descrElement = (Element)i.next();
                    Attribute attr = descrElement.attribute("name");
                    if (attr == null) {
                        attr = descrElement.attribute("id");
                    }
                    idText = attr.getValue();
                    descrText = descrElement.getText();
                    idToDescr.put(idText, descrText);
                }
                result.put(langId, idToDescr);
            }
            return true;
        }
        return false;
    }

    private static synchronized void loadTimeZones(String languageId) throws Exception {
        SAXReader reader;
        Document document;
        Element resources;
        List tzDescrElements;
        if (!m_resourcesLoaded) {
            ToolkitResources.loadResources();
        }
        String langId = null;
        langId = languageId == null || languageId.length() == 0 ? m_defaultLang : languageId;
        File file = ToolkitResources.findResourceFile(langId, I18N_TIMEZONE_RES_BASE);
        if (file != null && (tzDescrElements = (resources = (document = (reader = new SAXReader()).read(file)).getRootElement()).selectNodes("/stringTable/component[@name='CCL']/section[@name='TZ']/*")) != null) {
            Iterator i = tzDescrElements.iterator();
            Element tzDescrElement = null;
            String tzIDText = null;
            String tzDescrText = null;
            Hashtable<String, String> tzIDToDescr = new Hashtable<String, String>();
            StringBuffer tmpBuffer = null;
            int index = 0;
            String doubleDot = "..";
            String plusSign = "+";
            char forwardSlash = '/';
            while (i.hasNext()) {
                tzDescrElement = (Element)i.next();
                tzIDText = tzDescrElement.attribute("id").getValue();
                index = tzIDText.indexOf(doubleDot);
                if (index >= 0) {
                    tmpBuffer = new StringBuffer(tzIDText);
                    tzIDText = tmpBuffer.replace(index, index + doubleDot.length(), new String(plusSign)).toString();
                }
                tzIDText = tzIDText.replace('.', forwardSlash);
                tzDescrText = tzDescrElement.getText();
                tzIDToDescr.put(tzIDText, tzDescrText);
            }
            m_timeZones.put(langId, tzIDToDescr);
        }
    }

    private static String normalizeLocaleNameToResourceFormat(String localeId) {
        if (localeId == null || localeId.length() == 0) {
            return m_defaultLang;
        }
        StringBuffer result = new StringBuffer(localeId);
        int indDash = localeId.indexOf(45);
        int indDot = localeId.indexOf(46);
        if (indDash < 0) {
            if (indDot >= 0) {
                result = result.replace(indDot, indDot + 1, new String("--"));
            }
        } else if (indDot >= 0) {
            result = result.replace(indDot, indDot + 1, new String("-"));
        }
        return result.toString().toLowerCase();
    }

    private static File findResourceFile(String localeId, String resBase) {
        String normLangId = ToolkitResources.normalizeLocaleNameToResourceFormat(localeId);
        File file = new File(ToolkitResources.convertToAbsolutePath(resBase + normLangId + I18N_RES_EXT));
        if (file.exists()) {
            return file;
        }
        int indDoubleDash = normLangId.lastIndexOf("--");
        if (indDoubleDash >= 0) {
            normLangId = normLangId.substring(0, indDoubleDash);
            file = new File(ToolkitResources.convertToAbsolutePath(resBase + normLangId + I18N_RES_EXT));
            if (file.exists()) {
                return file;
            }
        } else {
            int indDash = normLangId.lastIndexOf(45);
            if (indDash >= 0) {
                normLangId = normLangId.substring(0, indDash);
                file = new File(ToolkitResources.convertToAbsolutePath(resBase + normLangId + I18N_RES_EXT));
                if (file.exists()) {
                    return file;
                }
                indDash = normLangId.lastIndexOf(45);
                if (indDash >= 0) {
                    normLangId = normLangId.substring(0, indDash);
                    file = new File(ToolkitResources.convertToAbsolutePath(resBase + normLangId + I18N_RES_EXT));
                    if (file.exists()) {
                        return file;
                    }
                }
            }
        }
        normLangId = m_defaultLang;
        file = new File(ToolkitResources.convertToAbsolutePath(resBase + normLangId + I18N_RES_EXT));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getSymbolForCurrencyCode(String currencyCode) {
        return m_currncySymbolsMap.get(currencyCode);
    }

    public static List<String> getSeparatorsListForLocale(Locale locale) {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String theName = ToolkitResources.getDefaultLocaleForCurrentLocale(ToolkitResources.normalizeLocaleIdentifier(locale.toString()));
        List<String> theList = m_localeSeparatorsMap.get(theName);
        return theList;
    }

    public static String getListSeparator(Locale locale) {
        if (m_bUSE_IBM_ICU_RESOURCES) {
            String result = ";";
            return result;
        }
        if (m_localeSeparatorsMap != null && !m_localeSeparatorsMap.isEmpty()) {
            String theName = ToolkitResources.getDefaultLocaleForCurrentLocale(ToolkitResources.normalizeLocaleIdentifier(locale.toString()));
            List<String> theList = null;
            theList = m_localeSeparatorsMap.get(theName);
            if (theList != null) {
                return theList.get(1);
            }
        }
        String result = ";";
        String langName = locale.getLanguage().toLowerCase();
        String countryName = locale.getCountry().toUpperCase();
        if (langName.equalsIgnoreCase("zh") && (countryName.length() == 0 || countryName.equalsIgnoreCase("cn") || countryName.equalsIgnoreCase("hk") || countryName.equalsIgnoreCase("mo") || countryName.equalsIgnoreCase("sg") || countryName.equalsIgnoreCase("tw"))) {
            result = ",";
            return result;
        }
        if (langName.equalsIgnoreCase("ko") && (countryName.length() == 0 || countryName.equalsIgnoreCase("kr"))) {
            result = ",";
            return result;
        }
        if ((langName.equalsIgnoreCase("he") || langName.equalsIgnoreCase("iw")) && (countryName.length() == 0 || countryName.equalsIgnoreCase("il"))) {
            result = ",";
            return result;
        }
        if (langName.equalsIgnoreCase("hi") && (countryName.length() == 0 || countryName.equalsIgnoreCase("in"))) {
            result = ",";
            return result;
        }
        if (langName.equalsIgnoreCase(m_defaultLang) && (countryName.length() == 0 || countryName.equalsIgnoreCase("au") || countryName.equalsIgnoreCase("ca") || countryName.equalsIgnoreCase("ie") || countryName.equalsIgnoreCase("nz") || countryName.equalsIgnoreCase("us") || countryName.equalsIgnoreCase("gb") || countryName.equalsIgnoreCase("zw"))) {
            result = ",";
            return result;
        }
        if (langName.equalsIgnoreCase("es") && (countryName.equalsIgnoreCase("do") || countryName.equalsIgnoreCase("mx") || countryName.equalsIgnoreCase("pa") || countryName.equalsIgnoreCase("vs"))) {
            result = ",";
            return result;
        }
        if (langName.equalsIgnoreCase("ja") && (countryName.length() == 0 || countryName.equalsIgnoreCase("jp"))) {
            result = ",";
            return result;
        }
        return result;
    }

    public static String getListSeparator(String localeID) {
        return ToolkitResources.getListSeparator(ToolkitResources.getLocaleFromStringID(localeID));
    }

    public static String getLCIDForLocale(String localeID) {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String result = "0";
        String tmpResult = m_localeToLCID.get(ToolkitResources.getDefaultLocaleForCurrentLocale(ToolkitResources.normalizeLocaleIdentifier(localeID)));
        if (tmpResult != null) {
            result = tmpResult;
        }
        return result;
    }

    public static String getLocaleIdForLCID(String LCID) {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String result = "0";
        String tmpResult = m_LCIDToLocale.get(LCID);
        if (tmpResult != null) {
            result = tmpResult;
        }
        return result;
    }

    public static Character getZeroDigit(String localeID) {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Character result = Character.valueOf('0');
        Character tmpResult = m_localeZeroDigit.get(ToolkitResources.getDefaultLocaleForCurrentLocale(ToolkitResources.normalizeLocaleIdentifier(localeID)));
        if (tmpResult != null) {
            result = tmpResult;
        }
        return result;
    }

    public static String getISOCurrencyCodeForLCID(String LCID) {
        try {
            if (!m_resourcesLoaded) {
                ToolkitResources.loadResources();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String isoCode = null;
        int number = 0;
        try {
            number = Integer.parseInt(LCID);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (number <= 0) {
            isoCode = new String();
        } else {
            isoCode = m_LCIDToISO.get(LCID);
            if (isoCode == null || isoCode.length() == 0) {
                isoCode = new String();
            }
        }
        return isoCode;
    }

    private static synchronized void loadResources() throws Exception {
        if (m_resourcesLoaded) {
            return;
        }
        String theUSE_IBM_ICU_RESOURCES = System.getenv("USE_IBM_ICU_RESOURCES");
        if (theUSE_IBM_ICU_RESOURCES == null || theUSE_IBM_ICU_RESOURCES.isEmpty() || theUSE_IBM_ICU_RESOURCES.charAt(0) == 'N' || theUSE_IBM_ICU_RESOURCES.charAt(0) == 'n') {
            m_bUSE_IBM_ICU_RESOURCES = false;
        }
        if (m_backComaptTZ == null) {
            m_backComaptTZ = new Hashtable<String, String>(5);
            m_backComaptTZ.put("EST", "US/Eastern");
            m_backComaptTZ.put("MST", "US/Mountain");
            m_backComaptTZ.put("PST", "America/Los_Angeles");
            m_backComaptTZ.put("HST", "Pacific/Honolulu");
            m_backComaptTZ.put("CST", "America/Chicago");
        }
        if (m_backComaptOldTZ == null) {
            m_backComaptOldTZ = new Hashtable<String, String>(11);
            m_backComaptOldTZ.put("US/Eastern", "EST");
            m_backComaptOldTZ.put("Canada/Eastern", "EST");
            m_backComaptOldTZ.put("America/New_York", "EST");
            m_backComaptOldTZ.put("America/Toronto", "EST");
            m_backComaptOldTZ.put("America/Montreal", "EST");
            m_backComaptOldTZ.put("US/Mountain", "MST");
            m_backComaptOldTZ.put("Canada/Mountain", "MST");
            m_backComaptOldTZ.put("America/Denver", "MST");
            m_backComaptOldTZ.put("America/Shiprock", "MST");
            m_backComaptOldTZ.put("Navajo", "MST");
            m_backComaptOldTZ.put("Europe/Lisbon", "WET");
            m_backComaptOldTZ.put("Europe/London", "WET");
            m_backComaptOldTZ.put("Europe/Belfast", "WET");
            m_backComaptOldTZ.put("Europe/Dublin", "WET");
            m_backComaptOldTZ.put("Asia/Damascus", "ART");
            m_backComaptOldTZ.put("Asia/Beirut", "ART");
            m_backComaptOldTZ.put("Asia/Amman", "ART");
            m_backComaptOldTZ.put("Asia/Nicosia", "ART");
            m_backComaptOldTZ.put("Africa/Johannesburg", "CAT");
            m_backComaptOldTZ.put("Africa/Blantyre", "CAT");
            m_backComaptOldTZ.put("Africa/Tripoli", "CAT");
            m_backComaptOldTZ.put("Europe/Athens", "EET");
            m_backComaptOldTZ.put("Europe/Kiev", "EET");
            m_backComaptOldTZ.put("Europe/Sofia", "EET");
            m_backComaptOldTZ.put("Europe/Minsk", "EET");
            m_backComaptOldTZ.put("Europe/Bucharest", "EET");
            m_backComaptOldTZ.put("Europe/Vilnius", "EET");
            m_backComaptOldTZ.put("Europe/Tallinn", "EET");
            m_backComaptOldTZ.put("Africa/Asmera", "EAT");
            m_backComaptOldTZ.put("Africa/Kampala", "EAT");
            m_backComaptOldTZ.put("Africa/Nairobi", "EAT");
            m_backComaptOldTZ.put("Africa/Mogadishu", "EAT");
            m_backComaptOldTZ.put("Africa/Khartoum", "EAT");
            m_backComaptOldTZ.put("Australia/Melbourne", "AET");
            m_backComaptOldTZ.put("America/Buenos_Aires", "BET");
            m_backComaptOldTZ.put("America/Halifax", "America/Glace_Bay");
            m_backComaptOldTZ.put("America/Thule", "America/Glace_Bay");
            m_backComaptOldTZ.put("Atlantic/Bermuda", "America/Glace_Bay");
            m_backComaptOldTZ.put("America/Jamaica", "EST");
            m_backComaptOldTZ.put("America/Porto_Acre", "EST");
            m_backComaptOldTZ.put("America/Cambridge_Bay", "CST");
            m_backComaptOldTZ.put("America/Mexico_City", "CST");
            m_backComaptOldTZ.put("America/Edmonton", "MST");
            m_backComaptOldTZ.put("America/Yellowknife", "MST");
            m_backComaptOldTZ.put("America/Chihuahua", "MST");
            m_backComaptOldTZ.put("America/Tijuana", "PST");
            m_backComaptOldTZ.put("America/Vancouver", "PST");
            m_backComaptOldTZ.put("America/Juneau", "AST");
            m_backComaptOldTZ.put("America/Nome", "AST");
            m_backComaptOldTZ.put("America/Yakutat", "AST");
            m_backComaptOldTZ.put("Pacific/Tahiti", "HST");
            m_backComaptOldTZ.put("Pacific/Honolulu", "HST");
            m_backComaptOldTZ.put("Pacific/Midway", "MIT");
            m_backComaptOldTZ.put("Pacific/Niue", "MIT");
            m_backComaptOldTZ.put("Pacific/Pago_Pago", "MIT");
        }
        if (m_LCIDToLocale == null) {
            m_LCIDToLocale = new Hashtable<String, String>();
        }
        if (m_LCIDToISO == null) {
            m_LCIDToISO = new Hashtable<String, String>();
        }
        if (m_localeToLCID == null) {
            m_localeToLCID = new Hashtable<String, String>();
        }
        if (m_localeZeroDigit == null) {
            m_localeZeroDigit = new Hashtable<String, Character>();
        }
        if (m_timeZones == null) {
            m_timeZones = new Hashtable<String, Map<String, String>>(3);
        }
        if (m_tzFifoCache == null) {
            m_tzFifoCache = new ArrayList<String>(3);
        }
        if (m_translations == null) {
            m_translations = new Hashtable<String, Map<String, String>>(3);
        }
        if (m_translationsFifoCache == null) {
            m_translationsFifoCache = new ArrayList<String>(3);
        }
        if (m_currencyFifoCache == null) {
            m_currencyFifoCache = new ArrayList<String>(3);
        }
        if (m_currencies == null) {
            m_currencies = new Hashtable<String, Map<String, String>>(3);
        }
        if (m_localeFifoCache == null) {
            m_localeFifoCache = new ArrayList<String>(3);
        }
        if (m_locales == null) {
            m_locales = new Hashtable<String, Map<String, String>>(3);
        }
        if (m_localeSeparatorsMap == null) {
            m_localeSeparatorsMap = new Hashtable<String, List<String>>(3);
        }
        m_localeIDs = new ArrayList<String>();
        m_rtlLocales = new ArrayList<String>();
        m_timeZoneIDs = new ArrayList<String>();
        if (m_langToDefaultLocaleMap == null) {
            m_langToDefaultLocaleMap = new TreeMap<String, String>();
        }
        if (m_currncySymbolsMap == null) {
            m_currncySymbolsMap = new TreeMap<String, String>();
        }
        SAXParser parser = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            parser = factory.newSAXParser();
            File pathFile = new File(ToolkitResources.convertToAbsolutePath(I18N_CONFIG_RES_NAME));
            parser.parse(pathFile, (DefaultHandler)new ResourceXMLDataHandler());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        m_rtlLocales = Collections.unmodifiableList(m_rtlLocales);
        m_localeIDs = Collections.unmodifiableList(m_localeIDs);
        m_timeZoneIDs = Collections.unmodifiableList(m_timeZoneIDs);
        m_langToDefaultLocaleMap.put("zh", "zh-hans-cn");
        m_langToDefaultLocaleMap.put("zh-cn", "zh-hans-cn");
        m_langToDefaultLocaleMap.put("zh-sg", "zh-hans-sg");
        m_langToDefaultLocaleMap.put("zh-hk", "zh-hant-hk");
        m_langToDefaultLocaleMap.put("zh-mo", "zh-hant-mo");
        m_langToDefaultLocaleMap.put("zh-tw", "zh-hant-tw");
        m_resourcesLoaded = true;
    }

    static String convertToAbsolutePath(String path) {
        if (null != path) {
            if (path.length() > 0) {
                boolean isAbsolutePath;
                File f = new File(path);
                boolean bl = isAbsolutePath = f.isAbsolute() || path.charAt(0) == '/' || path.charAt(0) == '\\';
                if (!isAbsolutePath) {
                    String binDir = ToolkitResources.determineBinDir();
                    if (null != binDir && 0 < binDir.length()) {
                        try {
                            path = new File(binDir, path).getCanonicalPath();
                        }
                        catch (IOException ioe) {}
                    }
                } else {
                    try {
                        path = f.getCanonicalPath();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                path = ToolkitResources.determineBinDir();
            }
            return path.replace('\\', '/');
        }
        return null;
    }

    public static boolean isCJK(Locale locale) {
        String langName = locale.getLanguage();
        String lowerCaseLangName = langName.toLowerCase();
        if (lowerCaseLangName.charAt(0) == 'j' && lowerCaseLangName.charAt(1) == 'a') {
            return true;
        }
        if (lowerCaseLangName.charAt(0) == 'z' && lowerCaseLangName.charAt(1) == 'h') {
            return true;
        }
        return lowerCaseLangName.charAt(0) == 'k' && lowerCaseLangName.charAt(1) == 'o';
    }

    public static boolean isLocaleLanguageOnly(String locale) {
        int ind = locale.indexOf(45);
        if (ind > 0) {
            return false;
        }
        ind = locale.indexOf(46);
        if (ind > 0) {
            return false;
        }
        ind = locale.indexOf(95);
        return ind <= 0;
    }

    public static String getLocaleLanguage(String locale) {
        String langId = m_emptyString;
        int ind = locale.indexOf(45);
        if (ind > 0) {
            langId = locale.substring(0, ind);
            return langId;
        }
        if (ind == 0) {
            return langId;
        }
        ind = locale.indexOf(46);
        if (ind > 0) {
            langId = locale.substring(0, ind);
            return langId;
        }
        if (ind == 0) {
            return langId;
        }
        ind = locale.indexOf(95);
        if (ind > 0) {
            langId = locale.substring(0, ind);
            return langId;
        }
        if (ind == 0) {
            return langId;
        }
        langId = locale;
        return langId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String determineBinDir() {
        String binPath;
        Object object = m_mutex;
        synchronized (object) {
            binPath = m_binDirectoryPath;
        }
        String binFolderName = "bin";
        String propValue = System.getProperty("sun.arch.data.model");
        if (propValue != null) {
            if (propValue.equals("64")) {
                binFolderName = "bin64";
            }
        } else {
            propValue = System.getProperty("com.ibm.vm.bitmode");
            if (propValue != null && propValue.equals("64")) {
                binFolderName = "bin64";
            }
        }
        if (null == binPath) {
            File f;
            try {
                String cogExecPath = System.getProperty("COG_EXEC_PATH");
                if (null != cogExecPath) {
                    try {
                        binPath = new File(cogExecPath).getCanonicalPath();
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (null == binPath) {
                try {
                    String cogRoot = System.getProperty("COG_ROOT");
                    if (null != cogRoot) {
                        try {
                            binPath = new File(cogRoot, "./" + binFolderName).getCanonicalPath();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
            }
            if (null == binPath) {
                f = new File("../configuration/cogstartup.xml");
                try {
                    if (null != f && f.exists()) {
                        try {
                            binPath = new File("../" + binFolderName).getCanonicalPath();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
            }
            if (null == binPath) {
                try {
                    InputStream locationStream = Class.forName("com.cognos.i18n.ToolkitResources").getClassLoader().getResourceAsStream("cogroot.link");
                    if (null != locationStream) {
                        BufferedReader read = new BufferedReader(new InputStreamReader(locationStream));
                        try {
                            binPath = new File(read.readLine(), "./" + binFolderName).getCanonicalPath();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (SecurityException se) {
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            if (null != binPath) {
                f = new File(binPath);
                if (null == f || !f.isDirectory()) {
                    binPath = new String();
                }
            } else {
                binPath = new String();
            }
            Object object2 = m_mutex;
            synchronized (object2) {
                m_binDirectoryPath = binPath;
            }
        }
        return binPath;
    }
}

