/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FormatConverter
extends DefaultHandler {
    private static final String FORMAT = "format";
    private static final String XML_LANG = "xml:lang";
    private static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    private static final DocumentBuilderFactory DB_FACTORY = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final HashSet<String> ELEMENTS = new HashSet();
    private SAXParser saxParser = null;
    private DocumentBuilder documentBuilder = null;
    private Transformer transformer = null;
    private LinkedList<JSONObject> savedElements = new LinkedList();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!FORMAT.equals(qName)) {
            JSONObject aJFmt = new JSONObject();
            for (int i = 0; i < attributes.getLength(); ++i) {
                aJFmt.put((Object)attributes.getQName(i), (Object)attributes.getValue(i));
            }
            if (!this.savedElements.isEmpty()) {
                JSONObject parent = this.savedElements.getLast();
                parent.put((Object)qName, (Object)aJFmt);
            }
            this.savedElements.addLast(aJFmt);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!FORMAT.equals(qName)) {
            this.savedElements.removeLast();
        }
    }

    private synchronized SAXParser getSAXParser() {
        if (this.saxParser == null) {
            try {
                this.saxParser = SAX_FACTORY.newSAXParser();
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new MoserException(e);
            }
        }
        return this.saxParser;
    }

    private synchronized DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            try {
                this.documentBuilder = DB_FACTORY.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new MoserException(e);
            }
        }
        return this.documentBuilder;
    }

    private synchronized Transformer getTransformer() {
        if (this.transformer == null) {
            try {
                this.transformer = TRANSFORMER_FACTORY.newTransformer();
                this.transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            catch (TransformerConfigurationException e) {
                throw new MoserException(e);
            }
        }
        return this.transformer;
    }

    protected boolean needsUnescape(String xmlText) {
        return xmlText.indexOf("&amp;") != -1 || xmlText.indexOf("&lt;") != -1;
    }

    public String convert(String xmlText) {
        String decodedXml = xmlText;
        if (this.needsUnescape(xmlText)) {
            while (this.needsUnescape(decodedXml = StringEscapeUtils.unescapeXml((String)decodedXml))) {
            }
            SAXParser parser = this.getSAXParser();
            parser.reset();
            this.savedElements.clear();
            this.savedElements.addLast(new JSONObject());
            try {
                ByteArrayInputStream lstream = new ByteArrayInputStream(decodedXml.getBytes(StandardCharsets.UTF_8));
                parser.parse((InputStream)lstream, (DefaultHandler)this);
            }
            catch (IOException | SAXException e) {
                throw new MoserException(MoserError.GENERAL_ERROR, xmlText, e);
            }
            return this.savedElements.getLast().toString();
        }
        return xmlText;
    }

    public String revert(String jsonText) {
        return this.revertAndAddXMLLang(jsonText, null);
    }

    public String revertAndAddXMLLang(String jsonText, String defaultLang) {
        JSONObject jsonObj;
        String decodedJSON = StringEscapeUtils.unescapeJson((String)jsonText);
        try {
            jsonObj = JSONObject.parse((String)decodedJSON);
        }
        catch (IOException e) {
            throw new MoserException(MoserError.GENERAL_ERROR, jsonText, e);
        }
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.newDocument();
        Element format = doc.createElement(FORMAT);
        doc.appendChild(format);
        FormatConverter.revert(doc, jsonObj, format, defaultLang);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource domSource = new DOMSource(doc);
        Transformer autobots = this.getTransformer();
        try {
            autobots.transform(domSource, result);
        }
        catch (TransformerException e) {
            throw new MoserException(MoserError.GENERAL_ERROR, jsonText, e);
        }
        return writer.toString();
    }

    private static void revert(Document doc, JSONObject obj, Element element, String defaultLang) {
        for (Object e : obj.entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                JSONObject json = (JSONObject)value;
                Element ele = element;
                if (ELEMENTS.contains(name)) {
                    ele = doc.createElement(name);
                    element.appendChild(ele);
                    if (FormatConverter.needAddXMLLang(defaultLang, name, json)) {
                        ele.setAttribute(XML_LANG, defaultLang);
                    }
                } else if (json.isEmpty()) continue;
                FormatConverter.revert(doc, (JSONObject)entry.getValue(), ele, defaultLang);
                continue;
            }
            if (XML_LANG.equals(name) && !FormatConverter.langDefined(defaultLang)) continue;
            element.setAttribute(name, entry.getValue().toString());
        }
    }

    private static boolean langDefined(String lang) {
        return lang != null && !lang.isEmpty();
    }

    private static boolean needAddXMLLang(String lang, String name, JSONObject json) {
        if (!FormatConverter.langDefined(lang)) {
            return false;
        }
        if (json.isEmpty() || json.containsKey((Object)XML_LANG)) {
            return false;
        }
        return !name.equals("formatGroup") && !name.equals(FORMAT) && ELEMENTS.contains(name);
    }

    static {
        ELEMENTS.add("formatGroup");
        ELEMENTS.add(FORMAT);
        ELEMENTS.add("stringFormat");
        ELEMENTS.add("dateFormat");
        ELEMENTS.add("timeFormat");
        ELEMENTS.add("dateTimeFormat");
        ELEMENTS.add("intervalFormat");
        ELEMENTS.add("numberFormat");
        ELEMENTS.add("currencyFormat");
        ELEMENTS.add("percentFormat");
    }
}

