/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.ibm.bi.platform.moser.common.utils.BaseUpgrade;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ParquetUpgrade
extends BaseUpgrade {
    ParquetUpgrade(File configFile, String namespace, String user, String password, boolean verbose) throws CAMCryptoException, IOException, SAXException, ParserConfigurationException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        super(namespace, user, password, verbose, new URL(BaseUpgrade.findConfig(configFile, "gateway")));
    }

    ParquetUpgrade(String url, String namespace, String user, String password, boolean verbose, boolean ignoreSSL) throws CAMCryptoException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        super(namespace, user, password, verbose, new URL(url), ignoreSSL);
    }

    private static String usage() {
        return "Usage: " + NEWLINE + "\tOptions:" + NEWLINE + "\t\t-h : url pointing to the cognos server gateway [optional, if not provided uses the one from the config]" + NEWLINE + "\t\t-n : Authentication namespace, -u and -p required if specified [optional]" + NEWLINE + "\t\t-u : Namespace user, -n and -p required if specified [optional]" + NEWLINE + "\t\t-p : Namespace password, -n and -u required if specified [optional]" + NEWLINE + "\t\t-d :  display the information about parquet files   [optional]" + NEWLINE + "\t\t-k : ignore the SSL certificate validation [optional]" + NEWLINE + "\t\t-l : apply to only to the number of last used files [optional]" + NEWLINE + "\t\t-t : filter displayed results by task id (only works with -d)   [optional]" + NEWLINE + "\t\t-s : store id (will apply the command down to the hierarchy starting with the provided store ID)[optional]" + NEWLINE + "\t\t-m : smarts upgrade after the parquet conversion [optional]" + NEWLINE + "\t\t-a : smarts version upgrade only [optional]" + NEWLINE + "" + NEWLINE + "\tExamples:" + NEWLINE + "\t\tDisplay parquet files/datasets info:" + NEWLINE + "\t\t  ParquetMigrate -d -n namespace -u username -p password" + NEWLINE + "\t\tor" + NEWLINE + "\t\t  ParquetMigrate -d -h http://localhost:9300 -n namespace -u username -p password" + NEWLINE + NEWLINE + "\t\tUpgrade parquet files/datasets:" + NEWLINE + "\t\t  ParquetMigrate -n namespace -u username -p password" + NEWLINE + NEWLINE + "\t\tUpgrade parquet files/datasets and apply deep smart analysis:" + NEWLINE + "\t\t  ParquetMigrate -m -n namespace -u username -p password" + NEWLINE + NEWLINE;
    }

    public static void main(String[] args) {
        try {
            boolean allEmpty;
            Map<String, String> m = ParquetUpgrade.parseArgs(args);
            if (m.containsKey("-params")) {
                String paramFile = m.get("-params");
                byte[] line = Files.readAllBytes(Paths.get(paramFile, new String[0]));
                m.clear();
                m = ParquetUpgrade.parseArgs(ParquetUpgrade.parseLine(line));
            }
            String installLocation = m.get("-i");
            String namespace = m.get("-n");
            String user = m.get("-u");
            String password = m.get("-p");
            String numberOfLastUsed = m.get("-l");
            String taskID = m.get("-t");
            String search = m.get("-s");
            boolean convert = m.containsKey("-d");
            boolean ignoreSSL = m.containsKey("-k");
            boolean smartsOn = m.containsKey("-m");
            boolean smartsOnly = m.containsKey("-a");
            boolean verbose = m.containsKey("-v");
            String url = m.get("-h");
            boolean anyEmpty = ParquetUpgrade.isEmpty(namespace) || ParquetUpgrade.isEmpty(user) || ParquetUpgrade.isEmpty(password);
            boolean bl = allEmpty = ParquetUpgrade.isEmpty(namespace) && ParquetUpgrade.isEmpty(user) && ParquetUpgrade.isEmpty(password);
            if (anyEmpty && !allEmpty) {
                ParquetUpgrade.printOutput(ParquetUpgrade.usage());
                return;
            }
            if (installLocation == null) {
                installLocation = "..";
            }
            ParquetUpgrade.parquetUpgrade(installLocation, namespace, user, password, convert, verbose, ignoreSSL, url, numberOfLastUsed, taskID, search, smartsOn, smartsOnly);
        }
        catch (Exception e) {
            ParquetUpgrade.printOutput(ParquetUpgrade.usage());
            e.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void parquetUpgrade(String installLocation, String namespace, String user, String password, boolean convert, boolean verbose, boolean ignoreSSL, String url, String numberOfLastUsed, String taskID, String search, boolean smartsOn, boolean smartsOnly) throws CAMCryptoException, IOException, SAXException, ParserConfigurationException, InterruptedException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        ParquetUpgrade tool;
        File configFile = new File(installLocation + File.separator + "configuration" + File.separator + "cogstartup.xml");
        if (configFile.exists() && (url == null || url.isEmpty())) {
            tool = new ParquetUpgrade(configFile, namespace, user, password, verbose);
        } else if (url != null && !url.isEmpty()) {
            tool = new ParquetUpgrade(url, namespace, user, password, verbose, ignoreSSL);
        } else {
            ParquetUpgrade.printOutput(ParquetUpgrade.usage());
            ParquetUpgrade.printError("Cannot find configuration file: " + configFile.getAbsolutePath());
            return;
        }
        if (smartsOnly) {
            tool.upgradeSmarts(search);
            return;
        }
        if (convert) {
            tool.display(numberOfLastUsed, taskID, search);
            return;
        }
        tool.upgrade(numberOfLastUsed, search, smartsOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void display(String numberOfLastUsed, String taskID, String search) throws IOException {
        try {
            if (!this.doLogon()) {
                ParquetUpgrade.printOutput(ParquetUpgrade.usage());
                return;
            }
            this.getParquetInfo(null, numberOfLastUsed, search);
        }
        finally {
            this.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade(String numberOfLastUsed, String search, boolean smartsOn) throws IOException, InterruptedException {
        try {
            if (!this.doLogon()) {
                ParquetUpgrade.printOutput(ParquetUpgrade.usage());
                return;
            }
            this.upgradeAll(numberOfLastUsed, search, smartsOn);
        }
        finally {
            this.terminate();
        }
    }

    protected JSONArray upgradeSmarts(String search) throws IOException, InterruptedException {
        if (!this.doLogon()) {
            ParquetUpgrade.printOutput(ParquetUpgrade.usage());
            return null;
        }
        String path = "parquets/smarts";
        if (search != null && !search.isEmpty()) {
            path = path + "&searchPath=storeID(%27" + search + "%27)";
        }
        String response = this.httpClient.doPut(this.getModelingService(path), null, new Integer(200), null);
        ParquetUpgrade.printOutput(response);
        String taskId = this.waitTillTaskIsDone(response, 2L);
        return this.getParquetInfo(taskId, null, null);
    }

    private JSONArray upgradeAll(String numberOfLastUsed, String search, boolean smartsOn) throws IOException, InterruptedException {
        String path = "parquets?version=VERSION_1";
        if (numberOfLastUsed != null && !numberOfLastUsed.isEmpty()) {
            path = path + "&lastNumberUsed=" + numberOfLastUsed;
        }
        if (search != null && !search.isEmpty()) {
            path = path + "&searchPath=storeID(%27" + search + "%27)";
        }
        if (smartsOn) {
            path = path + "&smartsUpgrade=true";
        }
        String response = this.httpClient.doPut(this.getModelingService(path), null, new Integer(200), null);
        ParquetUpgrade.printOutput(response);
        String taskId = this.waitTillTaskIsDone(response, 1L);
        return this.getParquetInfo(taskId, null, null);
    }

    private JSONArray getParquetInfo(String taskId, String numberOfLastUsed, String search) throws IOException {
        String path = "parquets?version=";
        if (taskId != null && !taskId.isEmpty()) {
            path = path + "&taskid=" + taskId;
        }
        if (numberOfLastUsed != null && !numberOfLastUsed.isEmpty()) {
            path = path + "&lastNumberUsed=" + numberOfLastUsed;
        }
        if (search != null && !search.isEmpty()) {
            path = path + "&searchPath=storeID(%27" + search + "%27)";
        }
        String response = this.httpClient.doGet(this.getModelingService(path), new Integer(200), null, null);
        JSONArray jasonArray = null;
        try {
            jasonArray = JSONArray.parse((String)response);
            for (Object o : jasonArray) {
                JSONObject oJson = (JSONObject)o;
                ParquetUpgrade.printOutput(oJson.serialize());
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + " " + response);
        }
        return jasonArray;
    }

    private String waitTillTaskIsDone(String response, long time) throws IOException, InterruptedException {
        JSONObject jsonObject = JSONObject.parse((String)response);
        String taskId = (String)jsonObject.get((Object)"taskID");
        if (taskId != null && !"null".equalsIgnoreCase(taskId)) {
            while (true) {
                String url = this.getModelingService("tasks/" + taskId);
                String res = this.httpClient.doGet(url, new Integer(200), null, null);
                ParquetUpgrade.printOutput(res);
                jsonObject = JSONObject.parse((String)res);
                String state = (String)jsonObject.get((Object)"state");
                if ("NOT_AVAILABLE".equals(state)) break;
                TimeUnit.SECONDS.sleep(time);
            }
        }
        return taskId;
    }
}

