/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.converters;

import com.ibm.bi.platform.datasetutils.converters.ConverterOptions;
import com.ibm.bi.platform.datasetutils.converters.ParquetConverter;
import com.ibm.bi.platform.datasetutils.metadata.TabularRowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import org.apache.commons.io.IOUtils;
import org.apache.parquet.hadoop.ParquetWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericConverter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GenericConverter.class);
    protected State converterState;
    protected final String absoluteOutPath;
    protected TabularRowSchema rowSchema = new TabularRowSchema();
    protected ParquetWriter<ReadableRecord> pqWriter;
    protected Map<Integer, DecimalType> fieldIdToOriginalDecimalType = new HashMap<Integer, DecimalType>();
    protected final ConverterOptions converterOpts;

    protected GenericConverter(String outputLocation, ConverterOptions convOptions) {
        this.converterState = State.INIT;
        this.absoluteOutPath = outputLocation;
        this.converterOpts = convOptions;
        this.configureLogging();
    }

    public void release() {
        if (State.INIT == this.converterState) {
            LOGGER.warn("The converter has not been initialized properly.");
        } else if (State.CLOSED == this.converterState) {
            LOGGER.warn("The converter has already been closed.");
        }
        IOUtils.closeQuietly(this.pqWriter);
        this.pqWriter = null;
    }

    private void configureLogging() {
        URL urlJULprops = ParquetConverter.class.getResource("/dataset-utils-logging.properties");
        try (InputStream in = urlJULprops.openStream();){
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException ex) {
            LOGGER.warn("Problem loading dataset-utils-logging.properties");
        }
    }

    protected static enum State {
        INIT,
        READY,
        CLOSED,
        UNUSUABLE;

    }
}

