/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata;

import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class TabularRowSchema
implements RowSchema {
    private static final String JSON_COLUMNS = "columns";
    private final List<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();

    public void setColumns(List<ColumnMetadata> initialColumns) {
        this.columns.clear();
        this.columns.addAll(initialColumns);
    }

    public void appendColumn(ColumnMetadata column) {
        if (null == column) {
            throw new NullPointerException("The provided argument cannot be NULL.");
        }
        this.columns.add(column);
    }

    public void appendAllColumns(List<ColumnMetadata> extraColumns) {
        if (null == extraColumns) {
            throw new NullPointerException("The provided argument cannot be NULL.");
        }
        this.columns.addAll(extraColumns);
    }

    @Override
    public int getNumOfColumns() {
        return this.columns.size();
    }

    @Override
    public ColumnMetadata getColumnMetadata(int id) {
        return this.columns.get(id);
    }

    @Override
    public ColumnMetadata getColumnMetadata(String name) {
        return this.columns.stream().filter(c -> c.getName().equals(name)).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowSchema)) {
            return false;
        }
        RowSchema other = (RowSchema)o;
        if (this.getNumOfColumns() != other.getNumOfColumns()) {
            return false;
        }
        for (int i = 0; i < this.getNumOfColumns(); ++i) {
            if (this.getColumnMetadata(i).equals(other.getColumnMetadata(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.columns.hashCode();
    }

    public String toString() {
        try {
            return this.toJson().serialize(false);
        }
        catch (IOException ex) {
            return "";
        }
    }

    @Override
    public JSONObject toJson() {
        OrderedJSONObject json = new OrderedJSONObject();
        JSONArray columnsArr = new JSONArray(this.getNumOfColumns());
        for (ColumnMetadata col : this.columns) {
            columnsArr.add((Object)col.toJson());
        }
        json.put((Object)JSON_COLUMNS, (Object)columnsArr);
        return json;
    }

    public static TabularRowSchema fromJson(JSONObject json) {
        TabularRowSchema schema = new TabularRowSchema();
        JSONArray columnsArr = (JSONArray)json.get((Object)JSON_COLUMNS);
        for (int i = 0; i < columnsArr.size(); ++i) {
            JSONObject colJson = (JSONObject)columnsArr.get(i);
            schema.appendColumn(Column.fromJson(colJson));
        }
        return schema;
    }
}

