/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata.types;

import com.ibm.bi.platform.datasetutils.metadata.types.BaseType;
import com.ibm.bi.platform.datasetutils.metadata.types.CCLTypeCode;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;

public class StringType
extends BaseType {
    private final byte cclType;
    private final String xqeType;

    protected StringType() {
        this.cclType = 1;
        this.xqeType = "NVARCHAR(MAX)";
    }

    protected StringType(byte ccldType) {
        if (1 == ccldType) {
            this.cclType = 1;
            this.xqeType = "NVARCHAR(MAX)";
        } else if (16 == ccldType || 60 == ccldType) {
            this.cclType = (byte)16;
            this.xqeType = "INTERVAL_DAY_TO_SECOND".replaceAll("_", " ");
        } else if (17 == ccldType) {
            this.cclType = (byte)17;
            this.xqeType = "INTERVAL_YEAR_TO_MONTH".replaceAll("_", " ");
        } else {
            throw new IllegalArgumentException(String.format("The provided CCLDTYPE (%s) cannot be handled by this instance.", CCLTypeCode.getCCLTypeName(ccldType)));
        }
    }

    @Override
    public EIntrinsicType getIntrinsicType() {
        return EIntrinsicType.STRING;
    }

    @Override
    public byte getCCLTypeCode() {
        return this.cclType;
    }

    public boolean isIntervalYM() {
        return this.cclType == 17;
    }

    public boolean isIntervalDT() {
        return this.cclType == 16;
    }

    @Override
    public String toXQETypeString() {
        return this.xqeType;
    }
}

