/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata.types;

import com.ibm.bi.platform.datasetutils.metadata.types.BaseType;
import com.ibm.bi.platform.datasetutils.metadata.types.CCLTypeCode;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.metadata.types.TemporalType;

public class TimestampType
extends BaseType
implements TemporalType {
    private final byte cclType;
    private final String xqeType;

    protected TimestampType() {
        this.cclType = (byte)59;
        this.xqeType = "TIMESTAMP";
    }

    protected TimestampType(byte ccldType) {
        if (59 == ccldType) {
            this.cclType = (byte)59;
            this.xqeType = "TIMESTAMP";
        } else if (53 == ccldType) {
            this.cclType = (byte)53;
            this.xqeType = "TIMESTAMP WITH TIME ZONE";
        } else {
            throw new IllegalArgumentException(String.format("The provided CCLDTYPE (%s) cannot be handled by this instance.", CCLTypeCode.getCCLTypeName(ccldType)));
        }
    }

    @Override
    public EIntrinsicType getIntrinsicType() {
        return EIntrinsicType.TIMESTAMP;
    }

    @Override
    public boolean hasDate() {
        return true;
    }

    @Override
    public boolean hasTime() {
        return true;
    }

    @Override
    public boolean hasTimeZone() {
        return 53 == this.cclType;
    }

    @Override
    public byte getCCLTypeCode() {
        return this.cclType;
    }

    @Override
    public String toXQETypeString() {
        return this.xqeType.toUpperCase();
    }
}

