/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.parquet;

import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.parquet.DatasetWriteSupport;
import com.ibm.bi.platform.datasetutils.parquet.ParquetOptions;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import java.time.ZoneId;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class DatasetParquetWriterBuilder
extends ParquetWriter.Builder<ReadableRecord, DatasetParquetWriterBuilder> {
    private final RowSchema recordSchema;
    private ParquetOptions customOptions = null;
    private ParquetVersionEnum version = ParquetVersionEnum.VERSION_1;
    private ZoneId timeZoneId = null;

    public DatasetParquetWriterBuilder(Path file, RowSchema recordSchema) {
        super(file);
        if (null == recordSchema) {
            throw new NullPointerException("recordSchema must be non-null");
        }
        this.recordSchema = recordSchema;
    }

    public DatasetParquetWriterBuilder withCustomOptions(ParquetOptions options) {
        this.customOptions = options;
        return this.self();
    }

    public DatasetParquetWriterBuilder withParquetVersion(ParquetVersionEnum version) {
        this.version = version;
        return this.self();
    }

    public DatasetParquetWriterBuilder withTimeZoneId(ZoneId zoneId) {
        this.timeZoneId = zoneId;
        return this.self();
    }

    protected WriteSupport<ReadableRecord> getWriteSupport(Configuration config) {
        ParquetOptions effectiveOptions = new ParquetOptions();
        if (null != this.customOptions) {
            effectiveOptions.putAll(this.customOptions);
        }
        effectiveOptions.put("parquet.ca.version", this.version.getValue());
        if (null != this.timeZoneId) {
            effectiveOptions.put("parquet.time.zone-id", this.timeZoneId.getId());
        }
        return new DatasetWriteSupport(this.recordSchema, effectiveOptions);
    }

    protected DatasetParquetWriterBuilder self() {
        return this;
    }
}

