/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.parquet;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class SparkRowMetadataBuilder {
    private final List<JSONObject> fields = new ArrayList<JSONObject>();

    SparkRowMetadataBuilder() {
    }

    public SparkRowMetadataBuilder clear() {
        this.fields.clear();
        return this;
    }

    public SparkRowMetadataBuilder addDateField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "date", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addTimestampField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "timestamp", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addBinaryField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "binary", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addIntegerField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "integer", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addBooleanField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "boolean", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addLongField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "long", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addDoubleField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "double", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addFloatField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "float", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addShortField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "short", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addByteField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "byte", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addStringField(String name, boolean nullable, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, "string", nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addDecimalField(String name, boolean nullable, int precision, int scale, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonSimpleField(name, String.format("decimal(%d, %d)", precision, scale), nullable, extraMetadata));
        return this;
    }

    public SparkRowMetadataBuilder addComplexField(String name, boolean nullable, JSONObject complexType, Map<String, Object> extraMetadata) {
        this.fields.add(SparkRowMetadataBuilder.toJsonComplexField(name, complexType, nullable, extraMetadata));
        return this;
    }

    public JSONObject build() {
        OrderedJSONObject structJson = new OrderedJSONObject();
        JSONArray fieldsJsonArr = new JSONArray();
        this.fields.forEach(arg_0 -> ((JSONArray)fieldsJsonArr).add(arg_0));
        structJson.put((Object)"type", (Object)"struct");
        structJson.put((Object)"fields", (Object)fieldsJsonArr);
        return structJson;
    }

    private static JSONObject toJsonSimpleField(String name, String type, boolean nullable, Map<String, Object> extraMetadata) {
        OrderedJSONObject json = new OrderedJSONObject();
        OrderedJSONObject metaJson = new OrderedJSONObject();
        if (null != extraMetadata) {
            extraMetadata.forEach((arg_0, arg_1) -> ((JSONObject)metaJson).put(arg_0, arg_1));
        }
        json.put((Object)"name", (Object)name);
        json.put((Object)"type", (Object)type);
        json.put((Object)"nullable", (Object)nullable);
        json.put((Object)"metadata", (Object)metaJson);
        return json;
    }

    private static JSONObject toJsonComplexField(String name, JSONObject complexType, boolean nullable, Map<String, Object> extraMetadata) {
        OrderedJSONObject json = new OrderedJSONObject();
        OrderedJSONObject metaJson = new OrderedJSONObject();
        if (null != extraMetadata) {
            extraMetadata.forEach((arg_0, arg_1) -> ((JSONObject)metaJson).put(arg_0, arg_1));
        }
        json.put((Object)"name", (Object)name);
        complexType.forEach((arg_0, arg_1) -> ((JSONObject)json).put(arg_0, arg_1));
        json.put((Object)"nullable", (Object)nullable);
        json.put((Object)"metadata", (Object)metaJson);
        return json;
    }
}

