/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.metrics;

import com.ibm.neo.metrics.ArgTagger;
import com.ibm.neo.metrics.Metrics;
import com.ibm.neo.metrics.SampledMetric;

public class CounterMetric
extends SampledMetric<CounterCompletion> {
    public CounterMetric(String nameFormat) {
        this(nameFormat, 1.0, null);
    }

    public CounterMetric(String nameFormat, ArgTagger tagger) {
        this(nameFormat, 1.0, tagger);
    }

    public CounterMetric(String nameFormat, double sampleRate, ArgTagger tagger) {
        super(nameFormat, sampleRate, tagger);
    }

    public void count(long delta) {
        this.withArgs(new Object[0]).count(delta);
    }

    @Override
    public CounterCompletion withArgs(Object ... args) {
        return new CounterCompletion(args);
    }

    public class CounterCompletion {
        private final Object[] args;

        private CounterCompletion(Object[] args) {
            this.args = args;
        }

        public void count(long delta) {
            if (CounterMetric.this.isSampling()) {
                if (CounterMetric.this.canSample()) {
                    String name = CounterMetric.this.getEffectiveName(this.args);
                    CounterMetric.this.processTags(this.args);
                    Metrics.count(name, delta, CounterMetric.this.getSampleRate());
                }
            } else {
                String name = CounterMetric.this.getEffectiveName(this.args);
                CounterMetric.this.processTags(this.args);
                Metrics.count(name, delta);
            }
        }
    }
}

