/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.metrics;

import com.ibm.neo.metrics.ArgTagger;
import com.ibm.neo.metrics.MetricBase;
import com.ibm.neo.metrics.Metrics;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class GaugeMetric
extends MetricBase<GaugeCompletion> {
    private final long sampleIntervalMillis;
    private final ConcurrentHashMap<String, Long> lastSampleTimeNanos;

    public GaugeMetric(String nameFormat) {
        this(nameFormat, 0L, null, null);
    }

    public GaugeMetric(String nameFormat, ArgTagger tagger) {
        this(nameFormat, 0L, null, tagger);
    }

    public GaugeMetric(String nameFormat, long sampleInterval, TimeUnit timeUnit) {
        this(nameFormat, sampleInterval, timeUnit, null);
    }

    public GaugeMetric(String nameFormat, long sampleInterval, TimeUnit timeUnit, ArgTagger tagger) {
        super(nameFormat, tagger);
        if (sampleInterval > 0L) {
            if (null == timeUnit) {
                throw new IllegalArgumentException("timeUnit was null");
            }
            this.sampleIntervalMillis = timeUnit.toMillis(sampleInterval);
            this.lastSampleTimeNanos = new ConcurrentHashMap();
        } else {
            this.sampleIntervalMillis = 0L;
            this.lastSampleTimeNanos = null;
        }
    }

    public void gauge(long value) {
        this.withArgs(new Object[0]).gauge(value);
    }

    public void gauge(double value) {
        this.withArgs(new Object[0]).gauge(value);
    }

    @Override
    public GaugeCompletion withArgs(Object ... args) {
        return new GaugeCompletion(args);
    }

    private boolean trySample(String name) {
        if (this.sampleIntervalMillis > 0L) {
            long currentNanos = System.nanoTime();
            Long lastNanos = this.lastSampleTimeNanos.get(name);
            if (null != lastNanos) {
                long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(currentNanos - lastNanos);
                if (elapsedMillis < this.sampleIntervalMillis) {
                    return false;
                }
                return this.lastSampleTimeNanos.replace(name, lastNanos, currentNanos);
            }
            return null == this.lastSampleTimeNanos.putIfAbsent(name, currentNanos);
        }
        return true;
    }

    public class GaugeCompletion {
        private Object[] args;

        private GaugeCompletion(Object[] args) {
            this.args = args;
        }

        public void gauge(long value) {
            String name = GaugeMetric.this.getEffectiveName(this.args);
            if (GaugeMetric.this.trySample(name)) {
                GaugeMetric.this.processTags(this.args);
                Metrics.gauge(name, value);
            }
        }

        public void gauge(double value) {
            String name = GaugeMetric.this.getEffectiveName(this.args);
            if (GaugeMetric.this.trySample(name)) {
                GaugeMetric.this.processTags(this.args);
                Metrics.gauge(name, value);
            }
        }
    }
}

