/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.metrics;

import com.ibm.neo.metrics.ArgTagger;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public abstract class MetricBase<CompletionT> {
    private static final Locale FORMAT_LOCALE = new Locale("en", "US");
    private final String nameFormat;
    private final ArgTagger tagger;

    public MetricBase(String nameFormat, ArgTagger tagger) {
        if (StringUtils.isEmpty((String)nameFormat)) {
            throw new IllegalArgumentException("nameFormat must be a non-empty string");
        }
        this.nameFormat = nameFormat;
        this.tagger = tagger;
    }

    protected String getNameFormat() {
        return this.nameFormat;
    }

    protected void processTags(Object ... args) {
        if (null != this.tagger && args.length > 0) {
            this.tagger.processArgs(args);
        }
    }

    protected String getEffectiveName(Object ... args) {
        if (args.length == 0) {
            return this.nameFormat;
        }
        return String.format(FORMAT_LOCALE, this.nameFormat, args);
    }

    public abstract CompletionT withArgs(Object ... var1);
}

