/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.metrics;

import com.ibm.neo.metrics.IMetricsClient;
import com.ibm.neo.metrics.IMetricsClientFactory;
import com.ibm.neo.metrics.NoOpMetricClient;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Metrics {
    public static final String PROP_METRICS_CLIENT_FACTORY = "metrics.client.factory";
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private static final Object initSync = new Object();
    private static IMetricsClient currentClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeClient() {
        Object object = initSync;
        synchronized (object) {
            String factoryName = System.getProperty(PROP_METRICS_CLIENT_FACTORY);
            Properties config = new Properties();
            if (StringUtils.isNotEmpty((String)factoryName)) {
                config.put(PROP_METRICS_CLIENT_FACTORY, factoryName);
            }
            currentClient = Metrics.createClient(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminateClient() {
        Object object = initSync;
        synchronized (object) {
            IMetricsClient client = currentClient;
            if (null != client) {
                try {
                    client.close();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to close metric client", (Throwable)ex);
                }
            }
            currentClient = null;
        }
    }

    private static IMetricsClient createClient(Properties config) {
        IMetricsClientFactory factory;
        String factoryClassName = config.getProperty(PROP_METRICS_CLIENT_FACTORY);
        if (StringUtils.isEmpty((String)factoryClassName)) {
            LOGGER.warn("System property 'metric.client.factory' was not specified");
            LOGGER.info("Using No-Op metric client");
            return new NoOpMetricClient();
        }
        LOGGER.info("Loading factory class: {}", (Object)factoryClassName);
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            factory = (IMetricsClientFactory)factoryClass.newInstance();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load client factory class: " + factoryClassName, (Throwable)ex);
            LOGGER.info("Using No-Op metric client");
            return new NoOpMetricClient();
        }
        try {
            return factory.createClient(config);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create client", (Throwable)ex);
            LOGGER.info("Using No-Op metric client");
            return new NoOpMetricClient();
        }
    }

    public static void count(String metric, long delta) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.count(metric, delta);
        }
    }

    public static void countWithoutPrefix(String metric, long delta) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.countWithoutPrefix(metric, delta);
        }
    }

    public static void count(String metric, long delta, double sampleRate) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.count(metric, delta, sampleRate);
        }
    }

    public static void countWithoutPrefix(String metric, long delta, double sampleRate) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.countWithoutPrefix(metric, delta, sampleRate);
        }
    }

    public static void time(String metric, long millis) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.time(metric, Math.max(0L, millis));
        }
    }

    public static void timeWithoutPrefix(String metric, long millis) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.timeWithoutPrefix(metric, Math.max(0L, millis));
        }
    }

    public static void time(String metric, long millis, double sampleRate) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.time(metric, Math.max(0L, millis), sampleRate);
        }
    }

    public static void timeWithoutPrefix(String metric, long millis, double sampleRate) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.timeWithoutPrefix(metric, Math.max(0L, millis), sampleRate);
        }
    }

    public static void gauge(String metric, long value) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.gauge(metric, value);
        }
    }

    public static void gaugeWithoutPrefix(String metric, long value) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.gaugeWithoutPrefix(metric, value);
        }
    }

    public static void gauge(String metric, double value) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.gauge(metric, value);
        }
    }

    public static void gaugeWithoutPrefix(String metric, double value) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.gaugeWithoutPrefix(metric, value);
        }
    }

    public static void set(String metric, String value) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.set(metric, value);
        }
    }

    public static void setWithoutPrefix(String metric, String value) {
        IMetricsClient client = currentClient;
        if (null != client) {
            client.setWithoutPrefix(metric, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = initSync;
        synchronized (object) {
            Metrics.terminateClient();
            Metrics.initializeClient();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        Metrics.initializeClient();
    }

    private static final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            LOGGER.info("JVM shutdown detected; terminating client");
            Metrics.terminateClient();
        }
    }
}

