/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.metrics;

import com.ibm.neo.metrics.ArgTagger;
import com.ibm.neo.metrics.MetricBase;
import java.util.concurrent.ThreadLocalRandom;

public abstract class SampledMetric<CompletionT>
extends MetricBase<CompletionT> {
    private static final int PRECISION = 10000;
    private final double sampleRate;

    public SampledMetric(String nameFormat, double sampleRate, ArgTagger tagger) {
        super(nameFormat, tagger);
        if (sampleRate <= 0.0 || sampleRate > 1.0) {
            throw new IllegalArgumentException("sampleRate must be in range (0.0, 1.0]");
        }
        this.sampleRate = sampleRate;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public boolean isSampling() {
        return this.sampleRate < 1.0;
    }

    protected boolean canSample() {
        double threshold;
        double rand = ThreadLocalRandom.current().nextInt(10000);
        return rand < (threshold = Math.ceil(10000.0 * this.sampleRate));
    }
}

