/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.metrics;

import com.ibm.neo.metrics.Metrics;
import java.util.concurrent.ConcurrentHashMap;

public class TagWriter {
    private final String namespace;
    private final ConcurrentHashMap<String, String> knownTagValues = new ConcurrentHashMap();

    public TagWriter(String namespace) {
        if (null == namespace) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.namespace = namespace;
    }

    public void put(String tag, String value) {
        String name = String.format("%s.%s.%s", this.namespace, tag, value);
        if (this.knownTagValues.putIfAbsent(name, name) == null) {
            Metrics.countWithoutPrefix(name, 1L);
        }
    }
}

