/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.test;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class TrustedRequestMultipleFormatTest {
    private static final String TRUST_SEARCH_ALIAS = "//*[local-name()='CAMProtect']/*[local-name()='trustedValue']";
    private static String configFilePath;
    private static String soapFile1Path;
    private static String soapFile2Path;

    public int testTrustedRequestMultipleFormats(String soapFile1Path, String soapFile2Path) {
        CAMFactory cf = new CAMFactory();
        try {
            cf.initialize("<initializeDocument><serviceID>CAM</serviceID></initializeDocument>".getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        long soapSize1 = 0L;
        FileInputStream fis = null;
        byte[] soapToken1 = null;
        try {
            File soapFile1 = new File(soapFile1Path);
            soapSize1 = soapFile1.length();
            soapToken1 = new byte[(int)soapSize1];
            fis = new FileInputStream(soapFile1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        try {
            int bytesread1 = fis.read(soapToken1);
            fis.close();
            if (bytesread1 == -1) {
                System.out.println("TrustedRequestMultipleFormatTest: No soap data.\n");
                return -1;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        long soapSize2 = 0L;
        byte[] soapToken2 = null;
        try {
            File soapFile2 = new File(soapFile2Path);
            soapSize2 = soapFile2.length();
            soapToken2 = new byte[(int)soapSize2];
            fis = new FileInputStream(soapFile2);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        try {
            int bytesread2 = fis.read(soapToken2);
            fis.close();
            if (bytesread2 == -1) {
                System.out.println("TrustedRequestMultipleFormatTest: No soap data.\n");
                return -1;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        TrustedRequestSession ts = null;
        try {
            ts = cf.createTrustedSession();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        byte[] trustedToken1 = null;
        try {
            trustedToken1 = ts.setMessageTrust("id", soapToken1);
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        byte[] trustedToken2 = null;
        try {
            trustedToken2 = ts.setMessageTrust("id", soapToken2);
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        try {
            String str1 = CAMCryptoUtilities.getChildNodeValue(CAMCryptoUtilities.getDocumentFromToken(trustedToken1), TRUST_SEARCH_ALIAS);
            String str2 = CAMCryptoUtilities.getChildNodeValue(CAMCryptoUtilities.getDocumentFromToken(trustedToken2), TRUST_SEARCH_ALIAS);
            if (str1.compareTo(str2) != 0) {
                System.err.println("TrustedRequestMultipleFormatTest: The MAC value is different.");
                return -1;
            }
            System.out.println("TrustedRequestMultipleFormatTest: The MAC value is the same.");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            System.out.println("\n");
            return -1;
        }
        System.out.println("TrustedRequestMultipleFormatTest: Testing completed successfully!\n\n");
        return 1;
    }
}

