/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit;

import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.ProbeFactory;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.ProbeUtils;
import java.util.Date;
import java.util.Map;

public class AlertProbe {
    public static final String GENERIC_ALERT_CODE = "GENERIC_ALERT";
    private static final AlertSchema SCHEMA = new AlertSchema();
    private static final IProbe PROBE = ProbeFactory.create(SCHEMA, true);

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static void sendAlert(String message, Map<String, Object> details) {
        AlertProbe.sendAlert(GENERIC_ALERT_CODE, message, details, null);
    }

    public static void sendAlert(String code, String message, Map<String, Object> details, String runbook) {
        if (!PROBE.isEnabled()) {
            return;
        }
        IEvent event = PROBE.createEvent();
        event.setField(AlertProbe.SCHEMA.severity, "ALERT");
        event.setField(AlertProbe.SCHEMA.logMessage, message);
        if (null != code) {
            event.setField(AlertProbe.SCHEMA.code, code);
        }
        if (null != details) {
            event.setField(AlertProbe.SCHEMA.details, AlertProbe.renderDetails(details));
        }
        if (null != runbook) {
            event.setField(AlertProbe.SCHEMA.runbook, runbook);
        }
        event.commit();
    }

    private static String renderDetails(Map<String, Object> details) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> e : details.entrySet()) {
            builder.append(e.getKey()).append('=').append(ProbeUtils.value2String(e.getValue(), 2000)).append("\n");
        }
        return builder.toString();
    }

    public static final class Builder {
        private String code = "GENERIC_ALERT";
        private String message;
        private Map<String, Object> details;
        private String runbook;

        private Builder() {
        }

        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withDetails(Map<String, Object> details) {
            this.details = details;
            return this;
        }

        public Builder withRunbook(String runbook) {
            this.runbook = runbook;
            return this;
        }

        public void send() {
            AlertProbe.sendAlert(this.code, this.message, this.details, this.runbook);
        }
    }

    private static final class AlertSchema
    extends ProbeSchema {
        public final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField();
        public final ProbeSchema.Field<String> host = new ProbeSchema.HostField();
        public final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField();
        public final ProbeSchema.Field<String> severity = new ProbeSchema.StringField("severity");
        public final ProbeSchema.Field<String> logMessage = new ProbeSchema.StringField("logMessage");
        public final ProbeSchema.Field<String> code = new ProbeSchema.StringField("Code");
        public final ProbeSchema.Field<String> details = new ProbeSchema.StringField("Details");
        public final ProbeSchema.Field<String> runbook = new ProbeSchema.StringField("Runbook");

        protected AlertSchema() {
            super("Alert");
        }
    }
}

