/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit;

import com.ibm.neo.probekit.IProbeExtension;
import com.ibm.neo.probekit.ProbeSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class ExtendedProbeSchema
extends ProbeSchema {
    private final ProbeSchema mBaseSchema;
    private final IProbeExtension mExtension;
    private final List<ProbeSchema.Field<?>> mCombinedFields = new ArrayList();

    protected ExtendedProbeSchema(ProbeSchema baseSchema, IProbeExtension extension) {
        super(baseSchema.getName());
        this.mBaseSchema = baseSchema;
        this.mExtension = extension;
    }

    public final void computeCombinedFields() {
        this.mCombinedFields.clear();
        this.mCombinedFields.addAll(super.getFields());
        for (ProbeSchema.Field<?> f : this.mBaseSchema.getFields()) {
            if (super.containsFieldName(f.getName())) continue;
            this.mCombinedFields.add(f);
        }
    }

    public final ProbeSchema getBaseSchema() {
        return this.mBaseSchema;
    }

    public final IProbeExtension getExtension() {
        return this.mExtension;
    }

    @Override
    public final List<ProbeSchema.Field<?>> getFields() {
        return Collections.unmodifiableList(this.mCombinedFields);
    }

    @Override
    public final ProbeSchema.Field<?> getField(String name) {
        for (ProbeSchema.Field<?> f : this.mCombinedFields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    @Override
    public final boolean contains(ProbeSchema.Field<?> field) {
        return super.contains(field) || this.mBaseSchema.contains(field);
    }

    @Override
    public final boolean containsFieldName(String fieldName) {
        for (ProbeSchema.Field<?> f : this.mCombinedFields) {
            if (!f.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(this.mBaseSchema.toString()).append("extendedFields", super.getFields()).toString();
    }
}

