/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit;

import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IConfigManager;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.IProbeManager;
import com.ibm.neo.probekit.ISinkManager;
import com.ibm.neo.probekit.impl.ConfigManager;
import com.ibm.neo.probekit.impl.ProbeManager;
import com.ibm.neo.probekit.impl.SinkManager;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeKit {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbeKit.class);
    private static ProbeKit INSTANCE = new ProbeKit();
    private final ScheduledExecutorService mScheduler;
    private final ConfigManager mConfigManager;
    private final SinkManager mSinkManager;
    private final ProbeManager mProbeManager;

    public static ProbeKit getInstance() {
        return INSTANCE;
    }

    ProbeKit() {
        System.out.println("[ProbeKit] Initializing");
        this.mScheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("ProbeKit-Scheduler");
                t.setDaemon(true);
                return t;
            }
        });
        this.mConfigManager = new ConfigManager(this.mScheduler);
        this.mConfigManager.addObserver(new ConfigObserver());
        ConfigTree config = this.mConfigManager.getActiveConfiguration();
        this.mSinkManager = new SinkManager(this.mScheduler);
        this.mSinkManager.configure(config);
        this.mProbeManager = new ProbeManager(this, this.mScheduler);
        this.mProbeManager.configure(config);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        System.out.println("[ProbeKit] Ready");
    }

    public IConfigManager getConfigManager() {
        return this.mConfigManager;
    }

    public IProbeManager getProbeManager() {
        return this.mProbeManager;
    }

    public ISinkManager getSinkManager() {
        return this.mSinkManager;
    }

    public ScheduledExecutorService getScheduler() {
        return this.mScheduler;
    }

    public void recordEventOverflow(IProbe probe) {
        this.mProbeManager.onEventOverflow(probe);
    }

    private void shutdown() {
        System.out.println("[ProbeKit] JVM shutdown detected");
        try {
            this.mProbeManager.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.error("An unexpected error occured", (Throwable)ex);
        }
        try {
            this.mSinkManager.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.error("An unexpected error occured", (Throwable)ex);
        }
        try {
            this.mConfigManager.shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.error("An unexpected error occured", (Throwable)ex);
        }
        try {
            this.mScheduler.shutdownNow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.error("An unexpected error occured", (Throwable)ex);
        }
        System.out.println("[ProbeKit] Terminated");
    }

    private final class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("ProbeKit-ShutdownHook");
        }

        @Override
        public void run() {
            ProbeKit.this.shutdown();
        }
    }

    private final class ConfigObserver
    implements Observer {
        private ConfigObserver() {
        }

        @Override
        public synchronized void update(Observable observable, Object data) {
            System.out.println("[ProbeKit] Configuration change detected");
            ConfigTree config = (ConfigTree)data;
            ProbeKit.this.getSinkManager().configure(config);
            ProbeKit.this.getProbeManager().configure(config);
            System.out.println("[ProbeKit] Reconfigured");
        }
    }
}

