/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class ProbeSchema {
    private final String mName;
    private final List<Field<?>> mFields = new ArrayList();

    protected ProbeSchema(String name) {
        if (null == name) {
            throw new NullArgumentException("name");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (name.contains(".") || name.contains(" ") || name.contains(":")) {
            throw new IllegalArgumentException("name cannot contain the following characters: '.' (period), ' ' (space) or ':' (colon)");
        }
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field<?>> getFields() {
        return Collections.unmodifiableList(this.mFields);
    }

    public Field<?> getField(String name) {
        for (Field<?> f : this.mFields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public boolean contains(Field<?> field) {
        return this.mFields.contains(field);
    }

    public boolean containsFieldName(String fieldName) {
        for (Field<?> f : this.mFields) {
            if (!f.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private <T> void registerField(Field<T> field) {
        this.mFields.add(field);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.mName).append("fields", this.mFields).toString();
    }

    public class HostAddressField
    extends StringField {
        public HostAddressField() {
            super("HostAddress");
        }
    }

    @Deprecated
    public class HostNameField
    extends StringField {
        public HostNameField() {
            super("HostName");
        }
    }

    public class HostField
    extends StringField {
        public HostField() {
            super("host");
        }
    }

    public class CurrentMethodField
    extends StringField {
        public CurrentMethodField() {
            super("CurrentMethod");
        }
    }

    public class EndStackField
    extends StringField {
        private final int mMaxDepth;

        public EndStackField() {
            this(75);
        }

        public EndStackField(int maxDepth) {
            super("EndStack");
            this.mMaxDepth = maxDepth;
        }

        public int getMaxDepth() {
            return this.mMaxDepth;
        }
    }

    public class StartStackField
    extends StringField {
        private final int mMaxDepth;

        public StartStackField() {
            this(75);
        }

        public StartStackField(int maxDepth) {
            super("StartStack");
            this.mMaxDepth = maxDepth;
        }

        public int getMaxDepth() {
            return this.mMaxDepth;
        }
    }

    public class EndThreadField
    extends Field<String> {
        public EndThreadField() {
            super("EndThread", String.class);
        }
    }

    public class StartThreadField
    extends Field<String> {
        public StartThreadField() {
            super("StartThread", String.class);
        }
    }

    public class DurationTimeField
    extends LongField {
        private final Field<Date> startTime;
        private final Field<Date> endTime;

        public DurationTimeField(Field<Date> startTime, Field<Date> endTime) {
            super("Duration");
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public DurationTimeField(String name, Field<Date> startTime, Field<Date> endTime) {
            super(name);
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Field<Date> getStartTime() {
            return this.startTime;
        }

        public Field<Date> getEndTime() {
            return this.endTime;
        }
    }

    public class EndTimeField
    extends DateField {
        public EndTimeField() {
            super("EndTime");
        }
    }

    public class StartTimeField
    extends DateField {
        public StartTimeField() {
            super("StartTime");
        }
    }

    public class BooleanField
    extends Field<Boolean> {
        public BooleanField(String name) {
            super(name, Boolean.class);
        }
    }

    public class DoubleField
    extends Field<Double> {
        public DoubleField(String name) {
            super(name, Double.class);
        }
    }

    public class LongField
    extends Field<Long> {
        public LongField(String name) {
            super(name, Long.class);
        }
    }

    public class FloatField
    extends Field<Float> {
        public FloatField(String name) {
            super(name, Float.class);
        }
    }

    public class IntegerField
    extends Field<Integer> {
        public IntegerField(String name) {
            super(name, Integer.class);
        }
    }

    public class StringField
    extends Field<String> {
        public StringField(String name) {
            super(name, String.class);
        }
    }

    public class DateField
    extends Field<Date> {
        public DateField(String name) {
            super(name, Date.class);
        }
    }

    public abstract class Field<T> {
        private final String mName;
        private final Class<T> mValueType;

        protected Field(String name, Class<T> valueType) {
            this.mName = name;
            this.mValueType = valueType;
            ProbeSchema.this.registerField(this);
        }

        public final String getName() {
            return this.mName;
        }

        public final Class<T> getValueType() {
            return this.mValueType;
        }

        public boolean validateValue(Object value) {
            if (null == value) {
                return true;
            }
            return this.getValueType().isAssignableFrom(value.getClass());
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.mName).append("valueType", this.mValueType).toString();
        }
    }
}

