/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit;

import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ProbeUtils {
    private static String sCachedLocalHostName = null;
    private static String sCachedLocalHostAddress = null;

    private ProbeUtils() {
    }

    public static String renderStackTrace(Thread thread, int maxDepth) {
        return ProbeUtils.renderStackTrace(thread.getStackTrace(), maxDepth);
    }

    public static String renderStackTrace(StackTraceElement[] stack, int maxDepth) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int depth = 0;
        for (i = 0; i < stack.length; ++i) {
            StackTraceElement elem = stack[i];
            if (ProbeUtils.canSkipStackTraceElement(elem)) continue;
            builder.append(ProbeUtils.getClassSimpleName(elem.getClassName())).append('.').append(elem.getMethodName()).append('(').append(elem.getFileName()).append(':').append(elem.getLineNumber()).append(')').append("\n");
            if (++depth >= maxDepth) break;
        }
        if (i < stack.length) {
            builder.append("...");
        }
        return builder.toString();
    }

    public static String getCurrentMethod(Thread thread) {
        StackTraceElement[] stack = thread.getStackTrace();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (i = 0; i < stack.length; ++i) {
            StackTraceElement elem = stack[i];
            if (ProbeUtils.canSkipStackTraceElement(elem)) continue;
            builder.append(ProbeUtils.getClassSimpleName(elem.getClassName())).append('.').append(elem.getMethodName()).append('(').append(elem.getFileName()).append(':').append(elem.getLineNumber()).append(')');
            break;
        }
        return builder.toString();
    }

    private static boolean canSkipStackTraceElement(StackTraceElement elem) {
        return elem.getClassName().startsWith("com.ibm.neo.probekit") || elem.getClassName().startsWith("com.ibm.neo.aop.probes") || elem.getClassName().equals("java.lang.Thread") && elem.getMethodName().startsWith("getStackTrace");
    }

    public static String getClassSimpleName(String className) {
        int lastDotPos = className.lastIndexOf(46);
        if (-1 == lastDotPos) {
            return className;
        }
        return className.substring(lastDotPos + 1);
    }

    public static String getLocalHostName() {
        String localHostName = sCachedLocalHostName;
        if (null == localHostName) {
            try {
                InetAddress inetAddr = InetAddress.getLocalHost();
                localHostName = inetAddr.getCanonicalHostName().toLowerCase();
            }
            catch (Exception ex) {
                localHostName = "<unknown host>";
            }
            sCachedLocalHostName = localHostName;
        }
        return localHostName;
    }

    public static String getLocalHostAddress() {
        String localHostAddress = sCachedLocalHostAddress;
        if (null == localHostAddress) {
            try {
                InetAddress inetAddr = InetAddress.getLocalHost();
                localHostAddress = inetAddr.getHostAddress();
            }
            catch (Exception ex) {
                localHostAddress = "<unknown address>";
            }
            sCachedLocalHostAddress = localHostAddress;
        }
        return localHostAddress;
    }

    public static String getThreadDisplayName(Thread thread) {
        return thread.getName() + '(' + thread.getId() + ')';
    }

    public static String value2String(Object value, int maxWidth) {
        String answer = null;
        if (null == value) {
            answer = "<null>";
        } else if (value.getClass().isArray()) {
            answer = ProbeUtils.array2String(value, maxWidth);
        } else if (value instanceof Iterable) {
            answer = ProbeUtils.iterable2String((Iterable)value, maxWidth);
        } else if (value instanceof Map) {
            answer = ProbeUtils.map2String((Map)value, maxWidth);
        } else if (maxWidth >= 4) {
            answer = StringUtils.abbreviate((String)value.toString(), (int)maxWidth);
        } else {
            return "...";
        }
        return answer;
    }

    public static String array2String(Object array, int maxWidth) {
        if (maxWidth < 4) {
            return "...";
        }
        StringBuilder builder = new StringBuilder();
        int length = Array.getLength(array);
        builder.append('[');
        for (int i = 0; i < length; ++i) {
            int widthLeft;
            if (i > 0) {
                builder.append(',');
            }
            if ((widthLeft = maxWidth - builder.length()) <= 0) break;
            builder.append(ProbeUtils.value2String(Array.get(array, i), widthLeft));
        }
        builder.append(']');
        return StringUtils.abbreviate((String)builder.toString(), (int)maxWidth);
    }

    public static String iterable2String(Iterable<?> iterable, int maxWidth) {
        if (maxWidth < 4) {
            return "...";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append('[');
        for (Object e : iterable) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            int widthLeft = maxWidth - builder.length();
            if (widthLeft <= 0) break;
            builder.append(ProbeUtils.value2String(e, widthLeft));
        }
        builder.append(']');
        return StringUtils.abbreviate((String)builder.toString(), (int)maxWidth);
    }

    public static String map2String(Map<?, ?> map, int maxWidth) {
        if (null == map) {
            return null;
        }
        if (maxWidth < 4) {
            return "...";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append('[');
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            int widthLeft = maxWidth - builder.length();
            if (widthLeft <= 0) break;
            builder.append(ProbeUtils.value2String(e.getKey(), widthLeft));
            widthLeft = maxWidth - builder.length();
            if (widthLeft <= 0) break;
            builder.append('=');
            builder.append(ProbeUtils.value2String(e.getValue(), widthLeft));
        }
        builder.append(']');
        return StringUtils.abbreviate((String)builder.toString(), (int)maxWidth);
    }

    public static String object2Id(Object obj) {
        if (null == obj) {
            return "<null>";
        }
        return "@" + ProbeUtils.int2PaddedHex(System.identityHashCode(obj));
    }

    public static String int2PaddedHex(int n) {
        return String.format("%08X", n);
    }

    public static String unqualifyName(String name) {
        if (null == name) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (-1 != pos) {
            return name.substring(pos + 1);
        }
        return name;
    }
}

