/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl;

import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IConfigManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.Observable;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
extends Observable
implements IConfigManager {
    private static final String DEFAULT_CONFIG_FILE = "./probes.properties";
    private static final String DEFAULT_CONFIG_RELOAD_INTERVAL = "5";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private final ScheduledExecutorService mScheduler;
    private final ScheduledFuture<?> mReloaderFuture;
    private File mConfigFile;
    private ConfigTree mActiveConfig;
    private long mLastModified = 0L;

    public ConfigManager(ScheduledExecutorService scheduler) {
        this.mScheduler = scheduler;
        this.mConfigFile = new File(System.getProperty("probekit.config.file", DEFAULT_CONFIG_FILE));
        int reloadInterval = Integer.parseInt(System.getProperty("probekit.config.reload-interval", DEFAULT_CONFIG_RELOAD_INTERVAL));
        this.mActiveConfig = new ConfigTree();
        this.mReloaderFuture = this.mScheduler.scheduleWithFixedDelay(new Reloader(), reloadInterval, reloadInterval, TimeUnit.SECONDS);
        this.reload();
    }

    @Override
    public synchronized ConfigTree getActiveConfiguration() {
        return this.mActiveConfig;
    }

    @Override
    public synchronized void reload(Properties props) {
        this.mConfigFile = null;
        this.mLastModified = 0L;
        ConfigTree newConfig = new ConfigTree();
        newConfig.load(props);
        this.mActiveConfig = newConfig;
        this.setChanged();
        this.notifyObservers(newConfig);
    }

    @Override
    public synchronized void reload(File configFile) {
        this.mConfigFile = configFile;
        this.mLastModified = 0L;
        this.reload();
    }

    @Override
    public synchronized void reload() {
        if (null == this.mConfigFile || !this.mConfigFile.exists()) {
            return;
        }
        if (this.mConfigFile.lastModified() == this.mLastModified) {
            return;
        }
        this.mLastModified = this.mConfigFile.lastModified();
        Properties props = this.loadConfigFile();
        if (null == props) {
            return;
        }
        ConfigTree newConfig = new ConfigTree();
        newConfig.load(props);
        this.mActiveConfig = newConfig;
        this.setChanged();
        this.notifyObservers(newConfig);
    }

    public void shutdown() {
        this.mReloaderFuture.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfigFile() {
        Properties properties;
        if (null == this.mConfigFile || !this.mConfigFile.exists()) {
            return null;
        }
        LOGGER.info("Loading configuration file: {}", (Object)this.mConfigFile.getAbsolutePath());
        FileInputStream in = new FileInputStream(this.mConfigFile);
        try {
            Properties props = new Properties();
            props.load(in);
            properties = props;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load configuration file", (Throwable)ex);
                return null;
            }
        }
        in.close();
        return properties;
    }

    private final class Reloader
    implements Runnable {
        private Reloader() {
        }

        @Override
        public void run() {
            try {
                ConfigManager.this.reload();
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected exception", (Throwable)ex);
            }
        }
    }
}

