/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl;

import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.IProbeManager;
import com.ibm.neo.probekit.ProbeKit;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.impl.NoOpProbe;

public class DelayedInitProbe
implements IProbe {
    private final ProbeSchema mSchema;
    private final boolean mEnabledByDefault;
    private volatile IProbe mDelegate = null;

    public DelayedInitProbe(ProbeSchema schema, boolean isEnabledByDefault) {
        this.mSchema = schema;
        this.mEnabledByDefault = isEnabledByDefault;
    }

    private IProbe getDelegate() {
        IProbe theDelegate = this.mDelegate;
        if (null == theDelegate) {
            ProbeKit kit = ProbeKit.getInstance();
            if (null == kit) {
                return new NoOpProbe();
            }
            IProbeManager probeMan = kit.getProbeManager();
            theDelegate = probeMan.createProbe(this.mSchema, this.mEnabledByDefault);
            if (null == this.mDelegate) {
                this.mDelegate = theDelegate;
            }
        }
        return this.mDelegate;
    }

    @Override
    public ProbeSchema getSchema() {
        return this.getDelegate().getSchema();
    }

    @Override
    public boolean isEnabled() {
        return this.getDelegate().isEnabled();
    }

    @Override
    public ConfigTree.ConfigNode getConfig() {
        return this.getDelegate().getConfig();
    }

    @Override
    public IEvent createEvent() {
        return this.getDelegate().createEvent();
    }

    public String toString() {
        return this.getDelegate().toString();
    }
}

