/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl;

import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.ProbeKit;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.impl.ProbeEvent;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Probe
implements IProbe {
    public static final String CONFIG_ENABLED = "enabled";
    public static final String CONFIG_SINKS = "sinks";
    private final ProbeKit mKit;
    private ProbeSchema mSchema;
    private final boolean mEnabledByDefault;
    private volatile ConfigTree.ConfigNode mConfig;
    private volatile boolean mEnabledByConfig;
    private volatile String[] mSinkNames;

    public Probe(ProbeKit kit, ProbeSchema schema, boolean isEnableByDefault) {
        if (null == schema) {
            throw new NullArgumentException("schema");
        }
        this.mKit = kit;
        this.mSchema = schema;
        this.mEnabledByConfig = this.mEnabledByDefault = isEnableByDefault;
        this.mSinkNames = null;
    }

    @Override
    public ProbeSchema getSchema() {
        return this.mSchema;
    }

    void setSchema(ProbeSchema schema) {
        if (null == schema) {
            throw new NullArgumentException("schema");
        }
        this.mSchema = schema;
    }

    boolean isEnabledByConfig() {
        return this.mEnabledByConfig;
    }

    @Override
    public boolean isEnabled() {
        return this.mKit.getProbeManager().isEnabled(this);
    }

    @Override
    public IEvent createEvent() {
        ProbeEvent event = new ProbeEvent(this);
        this.mKit.getProbeManager().onStartEvent(event);
        return event;
    }

    @Override
    public ConfigTree.ConfigNode getConfig() {
        return this.mConfig;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.getSchema().getName()).toString();
    }

    void configure(ConfigTree.ConfigNode config) {
        this.mConfig = config;
        this.mEnabledByConfig = config.getChildBooleanValue(CONFIG_ENABLED, Boolean.valueOf(this.mEnabledByDefault));
        this.mSinkNames = Probe.parseSinkList(config.getChildStringValue(CONFIG_SINKS, null));
    }

    void commitEvent(IEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.mKit.getProbeManager().onCommitEvent(event);
        this.mKit.getSinkManager().writeToSinks(this.mSinkNames, event);
    }

    private static String[] parseSinkList(String str) {
        if (null == str) {
            return null;
        }
        String[] parts = str.trim().split(",");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        return parts;
    }
}

