/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl;

import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.impl.Probe;
import java.util.HashMap;

public class ProbeEvent
implements IEvent {
    private Probe mProbe;
    private HashMap<ProbeSchema.Field<?>, Object> mFields = new HashMap();

    protected ProbeEvent(Probe probe) {
        this.mProbe = probe;
    }

    @Override
    public IProbe getProbe() {
        return this.mProbe;
    }

    @Override
    public <T> T getField(ProbeSchema.Field<T> field) {
        ProbeSchema schema = this.mProbe.getSchema();
        if (schema.contains(field)) {
            return field.getValueType().cast(this.mFields.get(field));
        }
        throw new IllegalArgumentException("Field does not match the Schema");
    }

    @Override
    public <T> void setField(ProbeSchema.Field<T> field, T value) {
        ProbeSchema schema = this.mProbe.getSchema();
        if (schema.contains(field)) {
            if (!field.validateValue(value)) {
                throw new IllegalArgumentException("Unexpected value type");
            }
        } else {
            throw new IllegalArgumentException("Field does not match the Schema");
        }
        this.mFields.put(field, value);
    }

    @Override
    public void commit() {
        this.mProbe.commitEvent(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ProbeSchema schema = this.mProbe.getSchema();
        sb.append("[");
        for (ProbeSchema.Field<?> field : schema.getFields()) {
            sb.append(field.getName()).append("=").append(this.mFields.get(field)).append("\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

