/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl;

import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.ExtendedProbeSchema;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.IProbeExtension;
import com.ibm.neo.probekit.IProbeManager;
import com.ibm.neo.probekit.ProbeKit;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.ProbeUtils;
import com.ibm.neo.probekit.impl.EventOverflowCounter;
import com.ibm.neo.probekit.impl.Probe;
import com.ibm.neo.probekit.impl.SystemProbes;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeManager
implements IProbeManager {
    private static final String CONFIG_PROBES = "probekit.probes";
    private static final String CONFIG_EXTENSIONS = "probekit.extensions";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProbeManager.class);
    private final ProbeKit mKit;
    private final ScheduledExecutorService mScheduler;
    private final ConcurrentLinkedQueue<IProbeExtension> mExtensions = new ConcurrentLinkedQueue();
    private final HashMap<String, Probe> mSchemaName2Probe = new HashMap();
    private final EventOverflowCounter mEventOverflowCounter = new EventOverflowCounter();
    private ConfigTree mConfig;
    private SystemProbes mSysProbes;

    public ProbeManager(ProbeKit kit, ScheduledExecutorService scheduler) {
        this.mKit = kit;
        this.mScheduler = scheduler;
        this.mConfig = null;
        this.mSysProbes = null;
    }

    EventOverflowCounter getEventOverflowCounter() {
        return this.mEventOverflowCounter;
    }

    @Override
    public void onEventOverflow(IProbe probe) {
        this.mEventOverflowCounter.count(probe.getSchema().getName());
    }

    @Override
    public synchronized IProbe createProbe(ProbeSchema schema, boolean isEnabledByDefault) {
        LOGGER.debug("Creating probe: {}", (Object)schema);
        Probe probe = this.mSchemaName2Probe.get(schema.getName());
        if (null == probe) {
            ConfigTree.ConfigNode probeConfig = this.mConfig.getOrCreate("probekit.probes." + schema.getName(), null);
            probe = new Probe(this.mKit, this.extendSchema(schema), isEnabledByDefault);
            probe.configure(probeConfig);
            this.mSchemaName2Probe.put(schema.getName(), probe);
        }
        return probe;
    }

    @Override
    public synchronized void configure(ConfigTree config) {
        LOGGER.info("Configuring probes");
        if (null != this.mSysProbes) {
            this.mSysProbes.stopSampling();
            this.mSysProbes = null;
        }
        this.mConfig = config;
        this.loadExtensions();
        for (Probe probe : this.mSchemaName2Probe.values()) {
            ConfigTree.ConfigNode probeConfig = this.mConfig.getOrCreate("probekit.probes." + probe.getSchema().getName(), null);
            probe.configure(probeConfig);
            ProbeSchema baseSchema = this.unwrapSchema(probe.getSchema());
            probe.setSchema(this.extendSchema(baseSchema));
        }
        this.mSysProbes = new SystemProbes(this, config, this.mScheduler, this.mEventOverflowCounter);
    }

    @Override
    public synchronized void shutdown() {
        if (null != this.mSysProbes) {
            this.mSysProbes.stopSampling();
            this.mSysProbes = null;
        }
        this.mSchemaName2Probe.clear();
        this.mConfig = null;
    }

    @Override
    public boolean isEnabled(IProbe probe) {
        for (IProbeExtension ext : this.mExtensions) {
            Boolean enabled = ext.isProbeEnabled(probe);
            if (Boolean.TRUE.equals(enabled)) {
                return true;
            }
            if (!Boolean.FALSE.equals(enabled)) continue;
            return false;
        }
        return ((Probe)probe).isEnabledByConfig();
    }

    @Override
    public void onStartEvent(IEvent event) {
        IProbe probe = event.getProbe();
        ProbeSchema schema = probe.getSchema();
        for (ProbeSchema.Field<?> field : schema.getFields()) {
            String hostName;
            if (field instanceof ProbeSchema.StartTimeField) {
                event.setField((ProbeSchema.StartTimeField)field, new Date());
                continue;
            }
            if (field instanceof ProbeSchema.StartThreadField) {
                Thread thread = Thread.currentThread();
                event.setField((ProbeSchema.StartThreadField)field, ProbeUtils.getThreadDisplayName(thread));
                continue;
            }
            if (field instanceof ProbeSchema.StartStackField) {
                ProbeSchema.StartStackField ssf = (ProbeSchema.StartStackField)field;
                event.setField(ssf, ProbeUtils.renderStackTrace(Thread.currentThread(), ssf.getMaxDepth()));
                continue;
            }
            if (field instanceof ProbeSchema.CurrentMethodField) {
                event.setField((ProbeSchema.CurrentMethodField)field, ProbeUtils.getCurrentMethod(Thread.currentThread()));
                continue;
            }
            if (field instanceof ProbeSchema.HostField) {
                hostName = ProbeUtils.getLocalHostName();
                event.setField((ProbeSchema.HostField)field, hostName);
                continue;
            }
            if (field instanceof ProbeSchema.HostNameField) {
                hostName = ProbeUtils.getLocalHostName();
                event.setField((ProbeSchema.HostNameField)field, hostName);
                continue;
            }
            if (!(field instanceof ProbeSchema.HostAddressField)) continue;
            String hostAddress = ProbeUtils.getLocalHostAddress();
            event.setField((ProbeSchema.HostAddressField)field, hostAddress);
        }
        while (schema instanceof ExtendedProbeSchema) {
            IProbeExtension extension = ((ExtendedProbeSchema)schema).getExtension();
            if (null != extension) {
                extension.onStartEvent(event, (ExtendedProbeSchema)schema);
            }
            schema = ((ExtendedProbeSchema)schema).getBaseSchema();
        }
    }

    @Override
    public void onCommitEvent(IEvent event) {
        IProbe probe = event.getProbe();
        ProbeSchema schema = probe.getSchema();
        for (ProbeSchema.Field<?> field : schema.getFields()) {
            if (field instanceof ProbeSchema.EndTimeField) {
                event.setField((ProbeSchema.EndTimeField)field, new Date());
                continue;
            }
            if (field instanceof ProbeSchema.DurationTimeField) {
                long durationMillis = ProbeManager.durationMillis(event, (ProbeSchema.DurationTimeField)field);
                event.setField((ProbeSchema.DurationTimeField)field, durationMillis);
                continue;
            }
            if (field instanceof ProbeSchema.EndThreadField) {
                Thread thread = Thread.currentThread();
                event.setField((ProbeSchema.EndThreadField)field, ProbeUtils.getThreadDisplayName(thread));
                continue;
            }
            if (!(field instanceof ProbeSchema.EndStackField)) continue;
            ProbeSchema.EndStackField esf = (ProbeSchema.EndStackField)field;
            event.setField(esf, ProbeUtils.renderStackTrace(Thread.currentThread(), esf.getMaxDepth()));
        }
        while (schema instanceof ExtendedProbeSchema) {
            IProbeExtension extension = ((ExtendedProbeSchema)schema).getExtension();
            if (null != extension) {
                extension.onCommitEvent(event, (ExtendedProbeSchema)schema);
            }
            schema = ((ExtendedProbeSchema)schema).getBaseSchema();
        }
    }

    private static long durationMillis(IEvent event, ProbeSchema.DurationTimeField field) {
        Date startDate = event.getField(field.getStartTime());
        Date endDate = event.getField(field.getEndTime());
        if (null != startDate && null != endDate) {
            return endDate.getTime() - startDate.getTime();
        }
        return -1L;
    }

    private void loadExtensions() {
        this.mExtensions.clear();
        ConfigTree.ConfigNode extensionsNode = this.mConfig.get(CONFIG_EXTENSIONS);
        if (null != extensionsNode) {
            ClassLoader loader = this.getClass().getClassLoader();
            for (ConfigTree.ConfigNode n : extensionsNode.getChildren()) {
                IProbeExtension extension;
                String extensionName = n.getName();
                String className = n.stringValue(null);
                if (null == className || className.length() == 0) {
                    LOGGER.error("Extension '{}' is missing an implementation class", (Object)extensionName);
                    continue;
                }
                try {
                    Class<?> extensionClass = loader.loadClass(className);
                    extension = (IProbeExtension)extensionClass.newInstance();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to instantiate extension", (Throwable)ex);
                    continue;
                }
                try {
                    extension.configure(n);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to configure extension", (Throwable)ex);
                    continue;
                }
                LOGGER.info("Registered extension, '{}', of type, '{}'", (Object)extensionName, (Object)className);
                this.mExtensions.add(extension);
            }
        }
    }

    private ProbeSchema extendSchema(ProbeSchema schema) {
        if (null == schema) {
            throw new NullArgumentException("schema");
        }
        for (IProbeExtension extension : this.mExtensions) {
            ExtendedProbeSchema extendedSchema = extension.extendSchema(schema);
            if (null == extendedSchema) continue;
            if (extendedSchema.getName() != schema.getName()) {
                LOGGER.error("Failed to extend schema, '{}', with extension, '{}': Inconsistent schema names", (Object)schema.getName(), (Object)extension.getName());
                continue;
            }
            LOGGER.info("Extending schema, '{}', with extension, '{}'", (Object)schema.getName(), (Object)extension.getName());
            extendedSchema.computeCombinedFields();
            schema = extendedSchema;
        }
        return schema;
    }

    private ProbeSchema unwrapSchema(ProbeSchema schema) {
        if (null == schema) {
            throw new NullArgumentException("schema");
        }
        while (schema instanceof ExtendedProbeSchema) {
            schema = ((ExtendedProbeSchema)schema).getBaseSchema();
        }
        return schema;
    }
}

