/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl;

import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.ISink;
import com.ibm.neo.probekit.ISinkManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkManager
implements ISinkManager {
    private static final String CONFIG_SINKS = "probekit.sinks";
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkManager.class);
    private final Map<String, ISink> mName2Sink = new HashMap<String, ISink>();
    private final ReadWriteLock mRWLock = new ReentrantReadWriteLock();
    private final ScheduledExecutorService mScheduler;
    private volatile boolean mShutdown = false;

    public SinkManager(ScheduledExecutorService scheduler) {
        this.mScheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSinkNames() {
        this.mRWLock.readLock().lock();
        try {
            String[] stringArray = this.mName2Sink.keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISink getSink(String name) {
        this.mRWLock.readLock().lock();
        try {
            ISink iSink = this.mName2Sink.get(name);
            return iSink;
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSink(String name, ISink sink) {
        this.mRWLock.writeLock().lock();
        try {
            this.mName2Sink.put(name, sink);
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToSinks(String[] sinkNames, IEvent event) {
        this.mRWLock.readLock().lock();
        try {
            if (this.mShutdown) {
                return;
            }
            if (null != sinkNames) {
                for (String n : sinkNames) {
                    ISink s = this.mName2Sink.get(n);
                    if (null == s) continue;
                    try {
                        s.write(event);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to write to sink", (Throwable)ex);
                    }
                }
            } else {
                for (ISink s : this.mName2Sink.values()) {
                    try {
                        s.write(event);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to write to sink", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(ConfigTree config) {
        this.mRWLock.writeLock().lock();
        try {
            if (this.mShutdown) {
                return;
            }
            LOGGER.info("Configuring sinks");
            this.shutdownSinks();
            ConfigTree.ConfigNode sinksNode = config.get(CONFIG_SINKS);
            if (null == sinksNode) {
                LOGGER.warn("No sinks were configured!");
                return;
            }
            ClassLoader loader = SinkManager.class.getClassLoader();
            for (ConfigTree.ConfigNode n : sinksNode.getChildren()) {
                ISink sink;
                String sinkName = n.getName();
                String className = n.stringValue(null);
                if (null == className || className.length() == 0) {
                    LOGGER.error("Sink '{}' is missing implementation class", (Object)sinkName);
                    continue;
                }
                try {
                    Class<?> sinkClass = loader.loadClass(className);
                    sink = (ISink)sinkClass.newInstance();
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to instantiate sink", (Throwable)ex);
                    continue;
                }
                try {
                    sink.initialize(n, this.mScheduler);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to initialize sink", (Throwable)ex);
                    continue;
                }
                this.mName2Sink.put(sinkName, sink);
            }
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.mRWLock.writeLock().lock();
        try {
            if (this.mShutdown) {
                return;
            }
            this.mShutdown = true;
            this.shutdownSinks();
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    private void shutdownSinks() {
        for (Map.Entry<String, ISink> e : this.mName2Sink.entrySet()) {
            String name = e.getKey();
            ISink sink = e.getValue();
            try {
                LOGGER.info("Shutting down sink '{}'", (Object)name);
                sink.shutdown();
            }
            catch (Throwable ex) {
                LOGGER.error("Unexpected exception while during sink shutdown", ex);
            }
        }
        this.mName2Sink.clear();
    }
}

