/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl;

import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.IProbeManager;
import com.ibm.neo.probekit.ProbeKit;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.impl.EventOverflowCounter;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemProbes {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemProbes.class);
    public static final String CONFIG_SAMPLE_INTERVAL = "sample-interval";
    private static final long DEFAULT_SAMPLE_INTERVAL = 5000L;
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final String SPECIFICATION_TITLE = "Specification-Title";
    private static final String SPECIFICATION_VERSION = "Specification-Version";
    private static final String IMPLEMENTATION_TITLE = "Implementation-Title";
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    public static final HeartbeatProbeSchema HEARTBEAT_PROBE_SCHEMA = new HeartbeatProbeSchema();
    public static final CompVersProbeSchema COMP_VERS_PROBE_SCHEMA = new CompVersProbeSchema();
    public static final EventOverflowProbeSchema EVENT_OVERFLOW_PROBE_SCHEMA = new EventOverflowProbeSchema();
    public static final ProbeKitConfigSchema PROBE_KIT_CONFIG_PROBE_SCHEMA = new ProbeKitConfigSchema();
    public static final JvmOptionsSchema JVM_OPTIONS_PROBE_SCHEMA = new JvmOptionsSchema();
    private final IProbe mHeartbeatProbe;
    private final IProbe mCompVersProbe;
    private final IProbe mEventOverflowProbe;
    private final IProbe mProbeKitConfigProbe;
    private final IProbe mJvmOptionsProbe;
    private final EventOverflowCounter mOverflowCounter;
    private Future<?> mHeartbeatSampleFuture;
    private Future<?> mEventOverflowSampleFuture;

    public SystemProbes(IProbeManager probeManager, ConfigTree config, ScheduledExecutorService scheduler, EventOverflowCounter overflowCounter) {
        this.mHeartbeatProbe = probeManager.createProbe(HEARTBEAT_PROBE_SCHEMA, false);
        this.mCompVersProbe = probeManager.createProbe(COMP_VERS_PROBE_SCHEMA, false);
        this.mEventOverflowProbe = probeManager.createProbe(EVENT_OVERFLOW_PROBE_SCHEMA, false);
        this.mProbeKitConfigProbe = probeManager.createProbe(PROBE_KIT_CONFIG_PROBE_SCHEMA, false);
        this.mJvmOptionsProbe = probeManager.createProbe(JVM_OPTIONS_PROBE_SCHEMA, false);
        this.mOverflowCounter = overflowCounter;
        this.startSampling(scheduler);
    }

    private void startSampling(ScheduledExecutorService scheduler) {
        long sampleInterval = this.mHeartbeatProbe.getConfig().getChildLongValue(CONFIG_SAMPLE_INTERVAL, Long.valueOf(5000L));
        this.mHeartbeatSampleFuture = scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SystemProbes.this.sendHeartbeat();
            }
        }, sampleInterval, sampleInterval, TimeUnit.MILLISECONDS);
        sampleInterval = this.mEventOverflowProbe.getConfig().getChildLongValue(CONFIG_SAMPLE_INTERVAL, Long.valueOf(5000L));
        this.mEventOverflowSampleFuture = scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SystemProbes.this.sampleEventOverflows();
            }
        }, sampleInterval, sampleInterval, TimeUnit.MILLISECONDS);
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                SystemProbes.this.sampleJvmOptions();
                SystemProbes.this.sampleProbeKitConfig();
                SystemProbes.this.sampleCompVers();
            }
        }, 1L, TimeUnit.SECONDS);
    }

    public void stopSampling() {
        this.mHeartbeatSampleFuture.cancel(false);
        this.mEventOverflowSampleFuture.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleCompVers() {
        if (!this.mCompVersProbe.isEnabled()) {
            return;
        }
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Enumeration<URL> manifestUrls = loader.getResources(META_INF_MANIFEST_MF);
            while (manifestUrls.hasMoreElements()) {
                Properties manifestProps = new Properties();
                URL url = manifestUrls.nextElement();
                InputStream in = url.openStream();
                try {
                    manifestProps.load(in);
                }
                finally {
                    in.close();
                }
                if (!manifestProps.containsKey(SPECIFICATION_TITLE) && !manifestProps.contains(IMPLEMENTATION_TITLE) && !manifestProps.containsKey(BUNDLE_NAME)) continue;
                ArrayList<String> nameParts = new ArrayList<String>(2);
                ArrayList<String> versionParts = new ArrayList<String>(2);
                String part = manifestProps.getProperty(SPECIFICATION_TITLE);
                if (null != part) {
                    nameParts.add(part);
                    versionParts.add(manifestProps.getProperty(SPECIFICATION_VERSION));
                }
                if (null != (part = manifestProps.getProperty(IMPLEMENTATION_TITLE)) && !nameParts.contains(part)) {
                    nameParts.add(part);
                    versionParts.add(manifestProps.getProperty(IMPLEMENTATION_VERSION));
                }
                if (null != (part = manifestProps.getProperty(BUNDLE_NAME)) && !nameParts.contains(part)) {
                    nameParts.add(part);
                    versionParts.add(manifestProps.getProperty(BUNDLE_VERSION));
                }
                StringBuilder nameBuilder = new StringBuilder();
                for (int i = 0; i < nameParts.size(); ++i) {
                    if (i > 0) {
                        nameBuilder.append(" / ");
                    }
                    nameBuilder.append((String)nameParts.get(i));
                }
                StringBuilder versionBuilder = new StringBuilder();
                for (int i = 0; i < versionParts.size(); ++i) {
                    if (i > 0) {
                        versionBuilder.append(" / ");
                    }
                    versionBuilder.append((String)versionParts.get(i));
                }
                IEvent event = this.mCompVersProbe.createEvent();
                event.setField(SystemProbes.COMP_VERS_PROBE_SCHEMA.componentName, nameBuilder.toString());
                event.setField(SystemProbes.COMP_VERS_PROBE_SCHEMA.componentVersion, versionBuilder.toString());
                event.setField(SystemProbes.COMP_VERS_PROBE_SCHEMA.resourcePath, String.valueOf(url));
                event.setField(SystemProbes.COMP_VERS_PROBE_SCHEMA.severity, "INFO");
                event.setField(SystemProbes.COMP_VERS_PROBE_SCHEMA.logMessage, String.format("%s %s", nameBuilder.toString(), versionBuilder.toString()));
                event.commit();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to sample component versions", (Throwable)ex);
        }
    }

    private void sendHeartbeat() {
        if (!this.mHeartbeatProbe.isEnabled()) {
            return;
        }
        try {
            IEvent event = this.mHeartbeatProbe.createEvent();
            event.setField(SystemProbes.HEARTBEAT_PROBE_SCHEMA.severity, "INFO");
            event.setField(SystemProbes.HEARTBEAT_PROBE_SCHEMA.logMessage, "Heartbeat");
            event.commit();
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to send heartbeat", (Throwable)ex);
        }
    }

    private void sampleProbeKitConfig() {
        if (!this.mProbeKitConfigProbe.isEnabled()) {
            return;
        }
        try {
            ConfigTree config = ProbeKit.getInstance().getConfigManager().getActiveConfiguration();
            List nodes = config.getAllNodes();
            for (ConfigTree.ConfigNode n : nodes) {
                if (n.getValue() == null) continue;
                IEvent event = this.mProbeKitConfigProbe.createEvent();
                event.setField(SystemProbes.PROBE_KIT_CONFIG_PROBE_SCHEMA.key, n.getKey());
                event.setField(SystemProbes.PROBE_KIT_CONFIG_PROBE_SCHEMA.value, n.stringValue(""));
                event.setField(SystemProbes.PROBE_KIT_CONFIG_PROBE_SCHEMA.severity, "INFO");
                event.setField(SystemProbes.PROBE_KIT_CONFIG_PROBE_SCHEMA.logMessage, String.format("%s = %s", n.getKey(), n.stringValue("")));
                event.commit();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to send ProbeKit configuration", (Throwable)ex);
        }
    }

    private void sampleJvmOptions() {
        if (!this.mJvmOptionsProbe.isEnabled()) {
            return;
        }
        try {
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            IEvent event = this.mJvmOptionsProbe.createEvent();
            event.setField(SystemProbes.JVM_OPTIONS_PROBE_SCHEMA.inputArgs, String.valueOf(runtimeBean.getInputArguments()));
            event.setField(SystemProbes.JVM_OPTIONS_PROBE_SCHEMA.sysProps, String.valueOf(System.getProperties()));
            event.setField(SystemProbes.JVM_OPTIONS_PROBE_SCHEMA.env, String.valueOf(System.getenv()));
            event.setField(SystemProbes.JVM_OPTIONS_PROBE_SCHEMA.classPath, runtimeBean.getClassPath());
            if (runtimeBean.isBootClassPathSupported()) {
                event.setField(SystemProbes.JVM_OPTIONS_PROBE_SCHEMA.bootClassPath, runtimeBean.getBootClassPath());
            }
            event.setField(SystemProbes.JVM_OPTIONS_PROBE_SCHEMA.severity, "INFO");
            event.setField(SystemProbes.JVM_OPTIONS_PROBE_SCHEMA.logMessage, "JVM Options");
            event.commit();
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to send JVM Options", (Throwable)ex);
        }
    }

    private void sampleEventOverflows() {
        if (!this.mEventOverflowProbe.isEnabled()) {
            return;
        }
        try {
            Map<String, Long> samples = this.mOverflowCounter.sampleAndReset();
            for (Map.Entry<String, Long> e : samples.entrySet()) {
                IEvent event = this.mEventOverflowProbe.createEvent();
                event.setField(SystemProbes.EVENT_OVERFLOW_PROBE_SCHEMA.affectedProbe, e.getKey());
                event.setField(SystemProbes.EVENT_OVERFLOW_PROBE_SCHEMA.count, e.getValue());
                event.commit();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to sample event overflows", (Throwable)ex);
        }
    }

    private static final class JvmOptionsSchema
    extends ProbeSchema {
        public final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField(this);
        public final ProbeSchema.Field<String> host = new ProbeSchema.HostField(this);
        public final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField(this);
        public final ProbeSchema.Field<String> inputArgs = new ProbeSchema.StringField(this, "InputArguments");
        public final ProbeSchema.Field<String> classPath = new ProbeSchema.StringField(this, "ClassPath");
        public final ProbeSchema.Field<String> bootClassPath = new ProbeSchema.StringField(this, "BootClassPath");
        public final ProbeSchema.Field<String> sysProps = new ProbeSchema.StringField(this, "SystemProperties");
        public final ProbeSchema.Field<String> env = new ProbeSchema.StringField(this, "Env");
        public final ProbeSchema.Field<String> severity = new ProbeSchema.StringField(this, "severity");
        public final ProbeSchema.Field<String> logMessage = new ProbeSchema.StringField(this, "logMessage");

        protected JvmOptionsSchema() {
            super("JvmOptions");
        }
    }

    private static final class ProbeKitConfigSchema
    extends ProbeSchema {
        public final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField(this);
        public final ProbeSchema.Field<String> host = new ProbeSchema.HostField(this);
        public final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField(this);
        public final ProbeSchema.Field<String> key = new ProbeSchema.StringField(this, "Key");
        public final ProbeSchema.Field<String> value = new ProbeSchema.StringField(this, "Value");
        public final ProbeSchema.Field<String> severity = new ProbeSchema.StringField(this, "severity");
        public final ProbeSchema.Field<String> logMessage = new ProbeSchema.StringField(this, "logMessage");

        protected ProbeKitConfigSchema() {
            super("ProbeKitConfig");
        }
    }

    private static final class EventOverflowProbeSchema
    extends ProbeSchema {
        public final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField(this);
        public final ProbeSchema.Field<String> host = new ProbeSchema.HostField(this);
        public final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField(this);
        public final ProbeSchema.Field<String> affectedProbe = new ProbeSchema.StringField(this, "AffectedProbe");
        public final ProbeSchema.Field<Long> count = new ProbeSchema.LongField(this, "Count");
        public final ProbeSchema.Field<String> severity = new ProbeSchema.StringField(this, "severity");
        public final ProbeSchema.Field<String> logMessage = new ProbeSchema.StringField(this, "logMessage");

        protected EventOverflowProbeSchema() {
            super("EventOverflow");
        }
    }

    private static final class CompVersProbeSchema
    extends ProbeSchema {
        public final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField(this);
        public final ProbeSchema.Field<String> host = new ProbeSchema.HostField(this);
        public final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField(this);
        public final ProbeSchema.Field<String> componentName = new ProbeSchema.StringField(this, "ComponentName");
        public final ProbeSchema.Field<String> componentVersion = new ProbeSchema.StringField(this, "ComponentVersion");
        public final ProbeSchema.Field<String> resourcePath = new ProbeSchema.StringField(this, "ResourcePath");
        public final ProbeSchema.Field<String> severity = new ProbeSchema.StringField(this, "severity");
        public final ProbeSchema.Field<String> logMessage = new ProbeSchema.StringField(this, "logMessage");

        protected CompVersProbeSchema() {
            super("CompVers");
        }
    }

    private static final class HeartbeatProbeSchema
    extends ProbeSchema {
        public final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField(this);
        public final ProbeSchema.Field<String> host = new ProbeSchema.HostField(this);
        public final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField(this);
        public final ProbeSchema.Field<String> severity = new ProbeSchema.StringField(this, "severity");
        public final ProbeSchema.Field<String> logMessage = new ProbeSchema.StringField(this, "logMessage");

        protected HeartbeatProbeSchema() {
            super("Heartbeat");
        }
    }
}

