/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl.sinks;

import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.ProbeSchema;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class JsonEventSerializer {
    public static final FastDateFormat ISO_DATETIME_MS_TIME_ZONE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    private JsonEventSerializer() {
    }

    public static JSONObject serialize(IEvent event) {
        ProbeSchema schema = event.getProbe().getSchema();
        OrderedJSONObject jsonEvent = new OrderedJSONObject();
        jsonEvent.put((Object)"Probe", (Object)schema.getName());
        for (ProbeSchema.Field<?> field : schema.getFields()) {
            Object value = event.getField(field);
            if (value instanceof Date) {
                String dateStr = ISO_DATETIME_MS_TIME_ZONE_FORMAT.format(value);
                jsonEvent.put((Object)field.getName(), (Object)dateStr);
                continue;
            }
            jsonEvent.put((Object)field.getName(), value);
        }
        return jsonEvent;
    }
}

