/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl.sinks;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.ISink;
import com.ibm.neo.probekit.impl.sinks.JsonEventSerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileSink
implements ISink {
    public static final String CONFIG_OUTPUT_DIR = "output-dir";
    public static final String CONFIG_BASE_NAME = "base-name";
    public static final String CONFIG_FLUSH_INTERVAL = "flush-interval";
    private static final String DEFAULT_OUTPUT_DIR = "./";
    private static final String DEFAULT_BASE_NAME = "probe-events";
    private static final long DEFAULT_FLUSH_INTERVAL = 1000L;
    private static Logger LOGGER = LoggerFactory.getLogger(JsonFileSink.class);
    private final ConcurrentLinkedQueue<JSONObject> mQueue = new ConcurrentLinkedQueue();
    private String mName = null;
    private File mOutputFile = null;
    private BufferedWriter mWriter = null;
    private ScheduledFuture<?> mFlushFuture = null;
    private int mFlushErrorCount = 0;

    @Override
    public void initialize(ConfigTree.ConfigNode config, ScheduledExecutorService scheduler) throws Exception {
        this.mName = config.getName();
        File outputDir = new File(config.getChildStringValue(CONFIG_OUTPUT_DIR, DEFAULT_OUTPUT_DIR));
        String baseName = config.getChildStringValue(CONFIG_BASE_NAME, DEFAULT_BASE_NAME);
        if (!outputDir.exists()) {
            FileUtils.forceMkdir((File)outputDir);
        }
        this.mOutputFile = JsonFileSink.createOutputFile(outputDir, baseName);
        long flushInterval = config.getChildLongValue(CONFIG_FLUSH_INTERVAL, Long.valueOf(1000L));
        if (flushInterval < 1L) {
            throw new IllegalArgumentException("Illegal flush interval: " + flushInterval);
        }
        this.mWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mOutputFile), "UTF-8"));
        this.mFlushFuture = scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                JsonFileSink.this.flush();
            }
        }, flushInterval, flushInterval, TimeUnit.MILLISECONDS);
        LOGGER.info("[ProbeKit] Initialized {} [output-file: {}, flush-interval: {}]", new Object[]{this.mName, this.mOutputFile.getAbsolutePath(), flushInterval});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Exception {
        this.mFlushFuture.cancel(false);
        try {
            this.flush();
        }
        finally {
            this.mWriter.close();
        }
    }

    @Override
    public void write(IEvent event) throws Exception {
        JSONObject eventObj = JsonEventSerializer.serialize(event);
        this.mQueue.add(eventObj);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.mName).append("outputFile", (Object)this.mOutputFile).toString();
    }

    protected void flush() {
        block4: {
            int queueSize;
            if (LOGGER.isDebugEnabled() && (queueSize = this.mQueue.size()) > 0) {
                LOGGER.debug("Flushing {} events", (Object)this.mQueue.size());
            }
            try {
                JSONObject eventObj = this.mQueue.poll();
                while (null != eventObj) {
                    eventObj.serialize((Writer)this.mWriter);
                    this.mWriter.newLine();
                    eventObj = this.mQueue.poll();
                    this.mFlushErrorCount = 0;
                }
                this.mWriter.flush();
                this.mFlushErrorCount = 0;
            }
            catch (Exception ex) {
                ++this.mFlushErrorCount;
                if (this.mFlushErrorCount >= 10) break block4;
                LOGGER.error("[ProbeKit] Unexpected error while flushing events", (Throwable)ex);
            }
        }
    }

    private static File createOutputFile(File outputDir, String baseName) {
        long now = System.currentTimeMillis();
        String timestamp = DateFormatUtils.format((long)now, (String)"yyyy-MM-dd_HH-mm-ss-SSS", (Locale)Locale.US);
        String name = baseName + "_" + timestamp + ".json";
        return new File(outputDir, name);
    }
}

